"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStateManagers = void 0;
var _react = require("react");
var _redux = require("../redux");
var _tabs_storage_manager = require("../tabs_storage_manager");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useStateManagers = ({
  services,
  urlStateStorage,
  customizationContext
}) => {
  // syncing with the _t part URL
  const [tabsStorageManager] = (0, _react.useState)(() => (0, _tabs_storage_manager.createTabsStorageManager)({
    urlStateStorage,
    storage: services.storage,
    enabled: _constants.TABS_ENABLED
  }));
  const [runtimeStateManager] = (0, _react.useState)(() => (0, _redux.createRuntimeStateManager)());
  const [internalState] = (0, _react.useState)(() => (0, _redux.createInternalStateStore)({
    services,
    customizationContext,
    runtimeStateManager,
    urlStateStorage,
    tabsStorageManager
  }));
  (0, _react.useEffect)(() => {
    const stopUrlSync = tabsStorageManager.startUrlSync({
      // if `_t` in URL changes (for example via browser history), try to restore the previous state
      onChanged: urlState => {
        const {
          tabId: restoreTabId
        } = urlState;
        if (restoreTabId) {
          internalState.dispatch(_redux.internalStateActions.restoreTab({
            restoreTabId
          }));
        } else {
          // if tabId is not present in `_t`, clear all tabs
          internalState.dispatch(_redux.internalStateActions.clearAllTabs());
        }
      }
    });
    return () => {
      stopUrlSync();
    };
  }, [tabsStorageManager, internalState]);
  return (0, _react.useMemo)(() => ({
    internalState,
    runtimeStateManager
  }), [internalState, runtimeStateManager]);
};
exports.useStateManagers = useStateManagers;