"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleCasesAnalyticsSyncTasks = exports.registerCasesAnalyticsIndexesTasks = exports.createCasesAnalyticsIndexes = void 0;
var _backfill_task = require("./tasks/backfill_task");
var _synchronization_task = require("./tasks/synchronization_task");
var _attachments_index = require("./attachments_index");
var _cases_index = require("./cases_index");
var _comments_index = require("./comments_index");
var _activity_index = require("./activity_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCasesAnalyticsIndexes = ({
  esClient,
  logger,
  isServerless,
  taskManager
}) => {
  const casesIndex = (0, _cases_index.createCasesAnalyticsIndex)({
    logger,
    esClient,
    isServerless,
    taskManager
  });
  const casesAttachmentsIndex = (0, _comments_index.createCommentsAnalyticsIndex)({
    logger,
    esClient,
    isServerless,
    taskManager
  });
  const casesCommentsIndex = (0, _attachments_index.createAttachmentsAnalyticsIndex)({
    logger,
    esClient,
    isServerless,
    taskManager
  });
  const casesActivityIndex = (0, _activity_index.createActivityAnalyticsIndex)({
    logger,
    esClient,
    isServerless,
    taskManager
  });
  return Promise.all([casesIndex.upsertIndex(), casesAttachmentsIndex.upsertIndex(), casesCommentsIndex.upsertIndex(), casesActivityIndex.upsertIndex()]);
};
exports.createCasesAnalyticsIndexes = createCasesAnalyticsIndexes;
const registerCasesAnalyticsIndexesTasks = ({
  taskManager,
  logger,
  core,
  analyticsConfig
}) => {
  (0, _backfill_task.registerCAIBackfillTask)({
    taskManager,
    logger,
    core,
    analyticsConfig
  });
  (0, _synchronization_task.registerCAISynchronizationTask)({
    taskManager,
    logger,
    core,
    analyticsConfig
  });
};
exports.registerCasesAnalyticsIndexesTasks = registerCasesAnalyticsIndexesTasks;
const scheduleCasesAnalyticsSyncTasks = ({
  taskManager,
  logger
}) => {
  (0, _activity_index.scheduleActivityAnalyticsSyncTask)({
    taskManager,
    logger
  });
  (0, _cases_index.scheduleCasesAnalyticsSyncTask)({
    taskManager,
    logger
  });
  (0, _comments_index.scheduleCommentsAnalyticsSyncTask)({
    taskManager,
    logger
  });
  (0, _attachments_index.scheduleAttachmentsAnalyticsSyncTask)({
    taskManager,
    logger
  });
};
exports.scheduleCasesAnalyticsSyncTasks = scheduleCasesAnalyticsSyncTasks;