"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Connector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _form = require("../connector_selector/form");
var _fields_form = require("../connectors/fields_form");
var _schema = require("./schema");
var _utils = require("../utils");
var _kibana = require("../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("../../common/translations"));
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorComponent = ({
  connectors,
  isLoading,
  isLoadingConnectors
}) => {
  var _getConnectorById;
  const [{
    connectorId
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['connectorId']
  });
  const connector = (_getConnectorById = (0, _utils.getConnectorById)(connectorId, connectors)) !== null && _getConnectorById !== void 0 ? _getConnectorById : null;
  const {
    actions
  } = (0, _kibana.useApplicationCapabilities)();
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const hasReadPermissions = permissions.connectors && actions.read;
  const connectorIdConfig = (0, _utils.getConnectorsFormValidators)({
    config: _schema.schema.connectorId,
    connectors
  });
  if (!hasReadPermissions) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "create-case-connector-permissions-error-msg",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("span", null, i18n.READ_ACTIONS_PERMISSIONS_ERROR_MSG));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "connectorId",
    config: connectorIdConfig,
    component: _form.ConnectorSelector,
    componentProps: {
      connectors,
      dataTestSubj: 'caseConnectors',
      disabled: isLoading || isLoadingConnectors,
      idAria: 'caseConnectors',
      isLoading: isLoading || isLoadingConnectors
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_fields_form.ConnectorFieldsForm, {
    connector: connector
  }))));
};
ConnectorComponent.displayName = 'ConnectorComponent';
const Connector = exports.Connector = /*#__PURE__*/(0, _react.memo)(ConnectorComponent);