"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OPEN_CHANGE_POINT_IN_ML_APP_ACTION = void 0;
exports.createOpenChangePointInMlAppAction = createOpenChangePointInMlAppAction;
var _public = require("@kbn/ui-actions-plugin/public");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OPEN_CHANGE_POINT_IN_ML_APP_ACTION = exports.OPEN_CHANGE_POINT_IN_ML_APP_ACTION = 'openChangePointInMlAppAction';
const getEmbeddableTimeRange = async embeddable => {
  var _embeddable$timeRange;
  const {
    apiHasParentApi,
    apiPublishesTimeRange
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/presentation-publishing')));
  let timeRange = (_embeddable$timeRange = embeddable.timeRange$) === null || _embeddable$timeRange === void 0 ? void 0 : _embeddable$timeRange.getValue();
  if (!timeRange && apiHasParentApi(embeddable) && apiPublishesTimeRange(embeddable.parentApi)) {
    timeRange = embeddable.parentApi.timeRange$.getValue();
  }
  return timeRange;
};
function createOpenChangePointInMlAppAction(coreStart, pluginStart) {
  return {
    id: 'open-change-point-in-ml-app',
    type: OPEN_CHANGE_POINT_IN_ML_APP_ACTION,
    getIconType(context) {
      return 'link';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.aiops.actions.openChangePointInMlAppName', {
      defaultMessage: 'Open in AIOps Labs'
    }),
    async getHref(context) {
      const {
        isChangePointChartEmbeddableContext
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./change_point_action_context')));
      if (!isChangePointChartEmbeddableContext(context)) {
        throw new _public.IncompatibleActionError();
      }
      const locator = pluginStart.share.url.locators.get('ML_APP_LOCATOR');
      const {
        metricField,
        fn,
        splitField,
        dataViewId
      } = context.embeddable;
      return locator.getUrl({
        page: 'aiops/change_point_detection',
        pageState: {
          index: dataViewId.getValue(),
          timeRange: await getEmbeddableTimeRange(context.embeddable),
          fieldConfigs: [{
            fn: fn.getValue(),
            metricField: metricField.getValue(),
            ...(splitField.getValue() ? {
              splitField: splitField.getValue()
            } : {})
          }]
        }
      });
    },
    async execute(context) {
      const {
        isChangePointChartEmbeddableContext
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./change_point_action_context')));
      if (!isChangePointChartEmbeddableContext(context)) {
        throw new _public.IncompatibleActionError();
      }
      const aiopsChangePointUrl = await this.getHref(context);
      if (aiopsChangePointUrl) {
        await coreStart.application.navigateToUrl(aiopsChangePointUrl);
      }
    },
    async isCompatible(context) {
      const {
        isChangePointChartEmbeddableContext
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./change_point_action_context')));
      return isChangePointChartEmbeddableContext(context);
    }
  };
}