"use strict";
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var node_os_1 = __importDefault(require("node:os"));
var node_url_1 = require("node:url");
var axios_1 = __importDefault(require("axios"));
var logger_1 = require("./logger");
var read_config_1 = require("./utils/read_config");
var config_service_1 = require("./config/config_service");
(function () { return __awaiter(void 0, void 0, void 0, function () {
    var logLevel, logger, configFile, rawConfig, config, basePath, host, port, ssl, protocol, healthCheckUrl, response, error_1;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                logLevel = process.env.HEALTHCHECK_LOGGING || 'warn';
                logger = (0, logger_1.getLogger)(logLevel);
                configFile = process.env.EMS_PATH_CONF || config_service_1.Constants.DEFAULT_EMS_PATH_CONF;
                rawConfig = (0, read_config_1.getConfigFromFiles)([configFile]);
                config = new config_service_1.ConfigurationService(rawConfig, logger);
                // The Configuration Service mutates
                // the logger, needs a level reset
                logger.level = logLevel;
                basePath = config.basePath, host = config.host, port = config.port, ssl = config.ssl;
                protocol = ssl.enabled ? 'https://' : 'http://';
                _a.label = 1;
            case 1:
                _a.trys.push([1, 3, , 4]);
                healthCheckUrl = new node_url_1.URL("".concat(protocol).concat(host || node_os_1.default.hostname(), ":").concat(port || 8080).concat(basePath, "/status"));
                // Disable certificate checking
                process.env.NODE_TLS_REJECT_UNAUTHORIZED = '0';
                // Query for the status endpoint
                logger.info("Checking status at ".concat(healthCheckUrl, "..."));
                return [4 /*yield*/, axios_1.default.head(healthCheckUrl.toString())];
            case 2:
                response = _a.sent();
                if ((response === null || response === void 0 ? void 0 : response.status) == 200) {
                    logger.info('Check was succesful');
                    process.exit(0);
                }
                else {
                    logger.warn("Healthcheck returned a ".concat(response.status, " code"));
                    process.exit(1);
                }
                return [3 /*break*/, 4];
            case 3:
                error_1 = _a.sent();
                logger.error('There was an error making the status check');
                logger.error(error_1);
                process.exit(1);
                return [3 /*break*/, 4];
            case 4: return [2 /*return*/];
        }
    });
}); })();
//# sourceMappingURL=healthcheck.js.map