"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBasePath = void 0;
var config_service_1 = require("./config_service");
var read_config_1 = require("../utils/read_config");
var pino_1 = __importDefault(require("pino"));
// Initialize logger
var logger = (0, pino_1.default)({ level: 'silent' });
var getBasePath = function () {
    var result = '';
    try {
        // Set up configuration
        var configFile = process.env.EMS_PATH_CONF || config_service_1.Constants.DEFAULT_EMS_PATH_CONF;
        var rawConfig = (0, read_config_1.getConfigFromFiles)([configFile]);
        var config = new config_service_1.ConfigurationService(rawConfig, logger);
        result = config.basePath || '';
    }
    catch (error) {
        logger.error({ error: error });
        process.exit(1);
    }
    finally {
        process.stdout.write(result + '\n');
    }
};
exports.getBasePath = getBasePath;
//# sourceMappingURL=getBasePath.js.map