/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 * This project is based on a modification of https://github.com/tdunning/t-digest which is licensed under the Apache 2.0 License.
 */

package org.elasticsearch.tdigest.arrays;

import org.apache.lucene.util.Accountable;
import org.elasticsearch.core.Releasable;

/**
 * Minimal interface for LongArray-like classes used within TDigest.
 */
public interface TDigestLongArray extends Releasable, Accountable {
    int size();

    long get(int index);

    void set(int index, long value);

    /**
     * Resizes the array. If the new size is bigger than the current size, the new elements are set to 0.
     */
    void resize(int newSize);
}
