/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.test.rest.ObjectPath;
import org.elasticsearch.test.rest.Stash;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class ClientYamlTestResponse {
    private final Response response;
    private final byte[] body;
    private final XContentType bodyContentType;
    private ObjectPath parsedResponse;
    private String bodyAsString;

    public ClientYamlTestResponse(Response response) throws IOException {
        this.response = response;
        if (response.getEntity() != null) {
            String contentType = response.getHeader("Content-Type");
            this.bodyContentType = ClientYamlTestResponse.getContentTypeIgnoreExceptions(contentType);
            try {
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                if (this.bodyContentType != null) {
                    if (bytes.length == 0) {
                        throw new IllegalArgumentException("Empty body is invalid for content-type [" + contentType + "]");
                    }
                    this.parsedResponse = ObjectPath.createFromXContent((XContent)this.bodyContentType.xContent(), (BytesReference)new BytesArray(bytes));
                }
                this.body = bytes;
            }
            catch (IOException e) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw e;
            }
        } else {
            this.body = null;
            this.bodyContentType = null;
        }
    }

    private static XContentType getContentTypeIgnoreExceptions(String contentType) {
        try {
            return XContentType.fromMediaType((String)contentType);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getReasonPhrase() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    public List<String> getWarningHeaders() {
        return this.getHeaders("Warning");
    }

    public List<String> getHeaders(String name) {
        ArrayList<String> headers = new ArrayList<String>();
        for (Header header : this.response.getHeaders()) {
            if (!header.getName().equalsIgnoreCase(name)) continue;
            headers.add(header.getValue());
        }
        return headers;
    }

    public Object getBody() throws IOException {
        if (this.parsedResponse != null) {
            return this.parsedResponse.evaluate("");
        }
        assert (this.bodyContentType == null);
        return this.getBodyAsString();
    }

    public String getBodyAsString() {
        if (this.bodyAsString == null && this.body != null) {
            if (this.bodyContentType == null || this.bodyContentType.canonical() == XContentType.JSON || this.bodyContentType.canonical() == XContentType.YAML) {
                this.bodyAsString = new String(this.body, StandardCharsets.UTF_8);
            } else {
                try (XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();){
                    try (XContentParser parser = this.bodyContentType.xContent().createParser(XContentParserConfiguration.EMPTY, this.body);){
                        jsonBuilder.copyCurrentStructure(parser);
                    }
                    this.bodyAsString = Strings.toString((XContentBuilder)jsonBuilder);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("unable to convert response body to a string format", e);
                }
            }
        }
        return this.bodyAsString;
    }

    public boolean isError() {
        return this.response.getStatusLine().getStatusCode() >= 400;
    }

    public <T> T evaluate(String path) throws IOException {
        return (T)this.evaluate(path, Stash.EMPTY);
    }

    public Object evaluate(String path, Stash stash) throws IOException {
        if (this.response == null) {
            return null;
        }
        if (this.parsedResponse == null) {
            if ("".equals(path) && "HEAD".equals(this.response.getRequestLine().getMethod())) {
                return !this.isError();
            }
            return null;
        }
        return this.parsedResponse.evaluate(path, stash);
    }
}

