/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.http.HttpBody;

public class FakeHttpBodyStream
implements HttpBody.Stream {
    private final List<HttpBody.ChunkHandler> tracingHandlers = new ArrayList<HttpBody.ChunkHandler>();
    private HttpBody.ChunkHandler handler;
    private boolean requested;
    private boolean closed;

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isRequested() {
        return this.requested;
    }

    public HttpBody.ChunkHandler handler() {
        return this.handler;
    }

    public void addTracingHandler(HttpBody.ChunkHandler chunkHandler) {
        this.tracingHandlers.add(chunkHandler);
    }

    public void setHandler(HttpBody.ChunkHandler chunkHandler) {
        this.handler = chunkHandler;
    }

    public void next() {
        if (this.closed) {
            return;
        }
        this.requested = true;
    }

    public void sendNext(ReleasableBytesReference chunk, boolean isLast) {
        if (this.requested) {
            for (HttpBody.ChunkHandler h : this.tracingHandlers) {
                h.onNext(chunk, isLast);
            }
        } else {
            throw new IllegalStateException("chunk is not requested");
        }
        this.handler.onNext(chunk, isLast);
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            for (HttpBody.ChunkHandler h : this.tracingHandlers) {
                h.close();
            }
            if (this.handler != null) {
                this.handler.close();
            }
        }
    }
}

