/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.Version;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.test.rest.TestFeatureService;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;

class ESRestTestFeatureService
implements TestFeatureService {
    private static final Pattern VERSION_FEATURE_PATTERN = Pattern.compile("gte_v(\\d+\\.\\d+\\.\\d+)");
    private final Collection<Version> nodeVersions;
    private final Collection<Set<String>> nodeFeatures;

    ESRestTestFeatureService(Set<Version> nodeVersions, Collection<Set<String>> nodeFeatures) {
        this.nodeVersions = nodeVersions;
        this.nodeFeatures = nodeFeatures;
    }

    private static <T> boolean checkCollection(Collection<T> coll, Predicate<T> pred, boolean any) {
        return any ? coll.stream().anyMatch(pred) : !coll.isEmpty() && coll.stream().allMatch(pred);
    }

    @Override
    public boolean clusterHasFeature(String featureId, boolean any) {
        if (ESRestTestFeatureService.checkCollection(this.nodeFeatures, s -> s.contains(featureId), any)) {
            return true;
        }
        if (MetadataHolder.FEATURE_NAMES.contains(featureId)) {
            return false;
        }
        Matcher matcher = VERSION_FEATURE_PATTERN.matcher(featureId);
        if (matcher.matches()) {
            Version extractedVersion = Version.fromString((String)matcher.group(1));
            if (extractedVersion.after((VersionId)Version.CURRENT)) {
                throw new IllegalArgumentException(Strings.format((String)"Cannot use a synthetic feature [%s] for a version after the current version [%s]", (Object[])new Object[]{featureId, Version.CURRENT}));
            }
            if (extractedVersion.equals((Object)Version.CURRENT)) {
                throw new IllegalArgumentException(Strings.format((String)"Cannot use a synthetic feature [%s] for the current version [%s]; please define a test cluster feature alongside the corresponding code change instead", (Object[])new Object[]{featureId, Version.CURRENT}));
            }
            return ESRestTestFeatureService.checkCollection(this.nodeVersions, v -> v.onOrAfter((VersionId)extractedVersion), any);
        }
        if (ESRestTestFeatureService.hasFeatureMetadata()) {
            if (ESRestTestFeatureService.isRestApiCompatibilityTest()) {
                return true;
            }
            throw new IllegalArgumentException(Strings.format((String)"Unknown feature %s: check the respective FeatureSpecification is provided both in module-info.java as well as in META-INF/services and verify the module is loaded during tests.", (Object[])new Object[]{featureId}));
        }
        return false;
    }

    private static boolean isRestApiCompatibilityTest() {
        return Boolean.parseBoolean(System.getProperty("tests.restCompat", "false"));
    }

    public static boolean hasFeatureMetadata() {
        return !MetadataHolder.FEATURE_NAMES.isEmpty();
    }

    private static class MetadataHolder {
        private static final Set<String> FEATURE_NAMES;

        private MetadataHolder() {
        }

        @SuppressForbidden(reason="File#pathSeparator has not equivalent in java.nio.file")
        private static void loadFeatureMetadata(String metadataPath, BiConsumer<String, Object> consumer) {
            String[] metadataFiles;
            for (String metadataFile : metadataFiles = metadataPath.split(File.pathSeparator)) {
                try (InputStream in = Files.newInputStream(PathUtils.get((String)metadataFile, (String[])new String[0]), new OpenOption[0]);
                     XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, in);){
                    parser.map().forEach(consumer);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        static {
            String metadataPath = System.getProperty("tests.features.metadata.path");
            if (metadataPath == null) {
                FEATURE_NAMES = Collections.emptySet();
            } else {
                HashSet featureNames = new HashSet();
                MetadataHolder.loadFeatureMetadata(metadataPath, (key, value) -> {
                    if (key.equals("feature_names") && value instanceof Collection) {
                        Collection collection = (Collection)value;
                        for (Object entry : collection) {
                            featureNames.add((String)entry);
                        }
                    }
                });
                FEATURE_NAMES = Collections.unmodifiableSet(featureNames);
            }
        }
    }
}

