/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.client;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.project.TestProjectResolvers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;

public class NoOpNodeClient
extends NodeClient {
    private final AtomicLong executionCount = new AtomicLong(0L);

    public NoOpNodeClient(ThreadPool threadPool) {
        super(Settings.EMPTY, threadPool, TestProjectResolvers.mustExecuteFirst());
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.executionCount.incrementAndGet();
        listener.onResponse(null);
    }

    public void initialize(Map<ActionType<?>, TransportAction<?, ?>> actions, TaskManager taskManager, Supplier<String> localNodeId, Transport.Connection localConnection, RemoteClusterService remoteClusterService) {
        throw new UnsupportedOperationException("cannot initialize " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.executionCount.incrementAndGet();
        listener.onResponse(null);
        return null;
    }

    public String getLocalNodeId() {
        return null;
    }

    public RemoteClusterClient getRemoteClusterClient(String clusterAlias, Executor responseExecutor, RemoteClusterService.DisconnectedStrategy disconnectedStrategy) {
        return null;
    }
}

