/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.test.ESTestCase;

public class EnumSerializationTestUtils {
    private EnumSerializationTestUtils() {
    }

    @SafeVarargs
    public static <E extends Enum<E>> void assertEnumSerialization(Class<E> clazz, E value0, E ... values) {
        Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
        ESTestCase.assertEquals((String)clazz.getCanonicalName(), (long)enumConstants.length, (long)(values.length + 1));
        for (int ordinal = 0; ordinal < values.length + 1; ++ordinal) {
            StreamInput in;
            BytesStreamOutput out;
            E enumValue = ordinal == 0 ? value0 : values[ordinal - 1];
            String description = clazz.getCanonicalName() + "[" + ordinal + "]";
            ESTestCase.assertEquals((String)description, (Object)enumConstants[ordinal], enumValue);
            try {
                out = new BytesStreamOutput(1);
                try {
                    out.writeEnum(enumValue);
                    in = out.bytes().streamInput();
                    try {
                        ESTestCase.assertEquals((String)description, (long)ordinal, (long)in.readVInt());
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                ESTestCase.fail(e);
            }
            try {
                out = new BytesStreamOutput(1);
                try {
                    out.writeVInt(ordinal);
                    in = out.bytes().streamInput();
                    try {
                        ESTestCase.assertEquals((String)description, enumValue, (Object)in.readEnum(clazz));
                        continue;
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                ESTestCase.fail(e);
            }
        }
    }
}

