/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.telemetry.MetricRecorder;
import org.elasticsearch.telemetry.metric.DoubleAsyncCounter;
import org.elasticsearch.telemetry.metric.DoubleCounter;
import org.elasticsearch.telemetry.metric.DoubleGauge;
import org.elasticsearch.telemetry.metric.DoubleHistogram;
import org.elasticsearch.telemetry.metric.DoubleUpDownCounter;
import org.elasticsearch.telemetry.metric.DoubleWithAttributes;
import org.elasticsearch.telemetry.metric.Instrument;
import org.elasticsearch.telemetry.metric.LongAsyncCounter;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.LongGauge;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.LongUpDownCounter;
import org.elasticsearch.telemetry.metric.LongWithAttributes;

public class RecordingInstruments {

    public static class RecordingLongUpDownCounter
    extends RecordingInstrument
    implements LongUpDownCounter {
        public RecordingLongUpDownCounter(String name, MetricRecorder<Instrument> recorder) {
            super(name, recorder);
        }

        public void add(long inc) {
            this.add(inc, Collections.emptyMap());
        }

        public void add(long inc, Map<String, Object> attributes) {
            this.call(inc, attributes);
        }
    }

    public static class RecordingLongHistogram
    extends RecordingInstrument
    implements LongHistogram {
        public RecordingLongHistogram(String name, MetricRecorder<Instrument> recorder) {
            super(name, recorder);
        }

        public void record(long value) {
            this.record(value, Collections.emptyMap());
        }

        public void record(long value, Map<String, Object> attributes) {
            this.call(value, attributes);
        }
    }

    public static class RecordingLongGauge
    extends CallbackRecordingInstrument
    implements LongGauge {
        public RecordingLongGauge(String name, Supplier<Collection<LongWithAttributes>> observer, MetricRecorder<Instrument> recorder) {
            super(name, () -> {
                Collection observation = (Collection)observer.get();
                return observation.stream().map(o -> new Tuple((Object)o.value(), (Object)o.attributes())).toList();
            }, recorder);
        }
    }

    public static class RecordingAsyncDoubleCounter
    extends CallbackRecordingInstrument
    implements DoubleAsyncCounter {
        public RecordingAsyncDoubleCounter(String name, Supplier<Collection<DoubleWithAttributes>> observer, MetricRecorder<Instrument> recorder) {
            super(name, () -> {
                Collection observation = (Collection)observer.get();
                return observation.stream().map(o -> new Tuple((Object)o.value(), (Object)o.attributes())).toList();
            }, recorder);
        }
    }

    public static class RecordingAsyncLongCounter
    extends CallbackRecordingInstrument
    implements LongAsyncCounter {
        public RecordingAsyncLongCounter(String name, Supplier<Collection<LongWithAttributes>> observer, MetricRecorder<Instrument> recorder) {
            super(name, () -> {
                Collection observation = (Collection)observer.get();
                return observation.stream().map(o -> new Tuple((Object)o.value(), (Object)o.attributes())).toList();
            }, recorder);
        }
    }

    public static class RecordingLongCounter
    extends RecordingInstrument
    implements LongCounter {
        public RecordingLongCounter(String name, MetricRecorder<Instrument> recorder) {
            super(name, recorder);
        }

        public void increment() {
            this.incrementBy(1L, Collections.emptyMap());
        }

        public void incrementBy(long inc) {
            this.incrementBy(inc, Collections.emptyMap());
        }

        public void incrementBy(long inc, Map<String, Object> attributes) {
            this.call(inc, attributes);
        }
    }

    public static class RecordingDoubleUpDownCounter
    extends RecordingInstrument
    implements DoubleUpDownCounter {
        public RecordingDoubleUpDownCounter(String name, MetricRecorder<Instrument> recorder) {
            super(name, recorder);
        }

        public void add(double inc) {
            this.add(inc, Collections.emptyMap());
        }

        public void add(double inc, Map<String, Object> attributes) {
            this.call(inc, attributes);
        }
    }

    public static class RecordingDoubleHistogram
    extends RecordingInstrument
    implements DoubleHistogram {
        public RecordingDoubleHistogram(String name, MetricRecorder<Instrument> recorder) {
            super(name, recorder);
        }

        public void record(double value) {
            this.record(value, Collections.emptyMap());
        }

        public void record(double value, Map<String, Object> attributes) {
            this.call(value, attributes);
        }
    }

    public static class RecordingDoubleGauge
    extends CallbackRecordingInstrument
    implements DoubleGauge {
        public RecordingDoubleGauge(String name, Supplier<Collection<DoubleWithAttributes>> observer, MetricRecorder<Instrument> recorder) {
            super(name, () -> {
                Collection observation = (Collection)observer.get();
                return observation.stream().map(o -> new Tuple((Object)o.value(), (Object)o.attributes())).toList();
            }, recorder);
        }
    }

    public static class RecordingDoubleCounter
    extends RecordingInstrument
    implements DoubleCounter {
        public RecordingDoubleCounter(String name, MetricRecorder<Instrument> recorder) {
            super(name, recorder);
        }

        public void increment() {
            this.incrementBy(1.0, Collections.emptyMap());
        }

        public void incrementBy(double inc) {
            this.incrementBy(inc, Collections.emptyMap());
        }

        public void incrementBy(double inc, Map<String, Object> attributes) {
            this.call(inc, attributes);
        }
    }

    protected static abstract class CallbackRecordingInstrument
    extends RecordingInstrument
    implements AutoCloseable,
    Runnable {
        private final NumberWithAttributesObserver observer;
        private boolean closed = false;
        private final ReleasableLock closedLock = new ReleasableLock((Lock)new ReentrantLock());

        public CallbackRecordingInstrument(String name, NumberWithAttributesObserver observer, MetricRecorder<Instrument> recorder) {
            super(name, recorder);
            this.observer = observer;
        }

        @Override
        public void run() {
            try (ReleasableLock lock = this.closedLock.acquire();){
                if (this.closed) {
                    return;
                }
                Collection observation = (Collection)this.observer.get();
                observation.forEach(o -> this.call((Number)o.v1(), (Map)o.v2()));
            }
        }

        @Override
        public void close() throws Exception {
            try (ReleasableLock lock = this.closedLock.acquire();){
                assert (!this.closed) : "double close";
                this.closed = true;
            }
        }
    }

    protected static interface NumberWithAttributesObserver
    extends Supplier<Collection<Tuple<Number, Map<String, Object>>>> {
    }

    protected static abstract class RecordingInstrument
    implements Instrument {
        protected final String name;
        private final MetricRecorder<Instrument> recorder;

        public RecordingInstrument(String name, MetricRecorder<Instrument> recorder) {
            this.name = Objects.requireNonNull(name);
            this.recorder = Objects.requireNonNull(recorder);
        }

        protected void call(Number value, Map<String, Object> attributes) {
            this.recorder.call(this, value, attributes);
        }

        public String getName() {
            return this.name;
        }
    }
}

