/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.transport.BytesRefRecycler;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class RestResponseUtils {
    private RestResponseUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BytesReference getBodyContent(RestResponse restResponse) {
        int pageSize;
        if (!restResponse.isChunked()) {
            return restResponse.content();
        }
        ChunkedRestResponseBodyPart firstResponseBodyPart = restResponse.chunkedContent();
        assert (!firstResponseBodyPart.isPartComplete());
        try (Recycler.V page = BytesRefRecycler.NON_RECYCLING_INSTANCE.obtain();){
            pageSize = ((BytesRef)page.v()).length;
        }
        try (BytesStreamOutput out = new BytesStreamOutput();){
            while (!firstResponseBodyPart.isPartComplete()) {
                ReleasableBytesReference chunk = firstResponseBodyPart.encodeChunk(pageSize, (Recycler)BytesRefRecycler.NON_RECYCLING_INSTANCE);
                try {
                    chunk.writeTo((OutputStream)out);
                }
                finally {
                    if (chunk == null) continue;
                    chunk.close();
                }
            }
            assert (firstResponseBodyPart.isLastPart()) : "RestResponseUtils#getBodyContent does not support continuations (yet)";
            out.flush();
            BytesReference bytesReference = out.bytes();
            return bytesReference;
        }
        catch (Exception e) {
            return (BytesReference)ESTestCase.fail(e);
        }
    }

    public static String getTextBodyContent(Iterator<CheckedConsumer<Writer, IOException>> iterator) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            while (iterator.hasNext()) {
                iterator.next().accept((Object)writer);
            }
            writer.flush();
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return (String)ESTestCase.fail(e);
            }
        }
        writer.close();
        return string;
    }

    public static <T extends ToXContent> T setUpXContentMock(T mock) {
        try {
            Mockito.when((Object)mock.toXContent((XContentBuilder)ArgumentMatchers.any(), (ToXContent.Params)ArgumentMatchers.any())).thenAnswer(invocation -> ESTestCase.asInstanceOf(XContentBuilder.class, invocation.getArgument(0)).startObject().endObject());
        }
        catch (IOException e) {
            ESTestCase.fail(e);
        }
        return mock;
    }
}

