/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.nio.file.Path;
import java.util.regex.Pattern;
import org.elasticsearch.common.Strings;

public enum RepositoryFileType {
    ROOT_INDEX_N("index-NUM"),
    ROOT_INDEX_LATEST("index.latest"),
    SNAPSHOT_INFO("snap-UUID.dat"),
    GLOBAL_METADATA("meta-UUID.dat"),
    INDEX_METADATA("indices/UUID/meta-SHORTUUID.dat"),
    SHARD_GENERATION("indices/UUID/NUM/index-UUID"),
    SHARD_SNAPSHOT_INFO("indices/UUID/NUM/snap-UUID.dat"),
    SHARD_DATA("indices/UUID/NUM/__UUID");

    private final Pattern pattern;

    private RepositoryFileType(String regex) {
        this.pattern = Pattern.compile("^(" + regex.replace("NUM", "(0|[1-9][0-9]*)").replace("SHORTUUID", "[0-9a-zA-Z_-]{20}").replace("UUID", "[0-9a-zA-Z_-]{22}") + ")$");
    }

    public static RepositoryFileType getRepositoryFileType(Path repositoryRoot, Path blobPath) {
        String relativePath = repositoryRoot.relativize(blobPath).toString().replace(repositoryRoot.getFileSystem().getSeparator(), "/");
        for (RepositoryFileType repositoryFileType : RepositoryFileType.values()) {
            if (!repositoryFileType.pattern.matcher(relativePath).matches()) continue;
            return repositoryFileType;
        }
        throw new IllegalArgumentException(Strings.format((String)"[%s] is not the path of a known blob type within [%s]", (Object[])new Object[]{relativePath, repositoryRoot}));
    }
}

