/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.mapper.AbstractScriptFieldTypeTestCase;
import org.hamcrest.Matchers;

public abstract class AbstractNonTextScriptFieldTypeTestCase
extends AbstractScriptFieldTypeTestCase {
    public void testFuzzyQueryIsError() {
        this.assertQueryOnlyOnTextAndKeyword("fuzzy", () -> this.simpleMappedFieldType().fuzzyQuery((Object)"cat", Fuzziness.AUTO, 0, 1, true, AbstractNonTextScriptFieldTypeTestCase.mockContext()));
    }

    public void testPrefixQueryIsError() {
        this.assertQueryOnlyOnTextKeywordAndWildcard("prefix", () -> this.simpleMappedFieldType().prefixQuery("cat", null, AbstractNonTextScriptFieldTypeTestCase.mockContext()));
    }

    public void testRegexpQueryIsError() {
        this.assertQueryOnlyOnTextAndKeyword("regexp", () -> this.simpleMappedFieldType().regexpQuery("cat", 0, 0, 10000, null, AbstractNonTextScriptFieldTypeTestCase.mockContext()));
    }

    public void testWildcardQueryIsError() {
        this.assertQueryOnlyOnTextKeywordAndWildcard("wildcard", () -> this.simpleMappedFieldType().wildcardQuery("cat", null, AbstractNonTextScriptFieldTypeTestCase.mockContext()));
    }

    private void assertQueryOnlyOnTextAndKeyword(String queryName, LuceneTestCase.ThrowingRunnable buildQuery) {
        Exception e = (Exception)AbstractNonTextScriptFieldTypeTestCase.expectThrows(IllegalArgumentException.class, (LuceneTestCase.ThrowingRunnable)buildQuery);
        AbstractNonTextScriptFieldTypeTestCase.assertThat(e.getMessage(), Matchers.equalTo((Object)("Can only use " + queryName + " queries on keyword and text fields - not on [test] which is a runtime field of type [" + this.typeName() + "]")));
    }

    private void assertQueryOnlyOnTextKeywordAndWildcard(String queryName, LuceneTestCase.ThrowingRunnable buildQuery) {
        Exception e = (Exception)AbstractNonTextScriptFieldTypeTestCase.expectThrows(IllegalArgumentException.class, (LuceneTestCase.ThrowingRunnable)buildQuery);
        AbstractNonTextScriptFieldTypeTestCase.assertThat(e.getMessage(), Matchers.equalTo((Object)("Can only use " + queryName + " queries on keyword, text and wildcard fields - not on [test] which is a runtime field of type [" + this.typeName() + "]")));
    }
}

