/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo;

import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;

public class GeometryPointCountVisitor
implements GeometryVisitor<Integer, RuntimeException> {
    public Integer visit(Circle circle) throws RuntimeException {
        return 2;
    }

    public Integer visit(GeometryCollection<?> collection) throws RuntimeException {
        int size = 0;
        for (Geometry geometry : collection) {
            size += ((Integer)geometry.visit((GeometryVisitor)this)).intValue();
        }
        return size;
    }

    public Integer visit(Line line) throws RuntimeException {
        return line.length();
    }

    public Integer visit(LinearRing ring) throws RuntimeException {
        return ring.length();
    }

    public Integer visit(MultiLine multiLine) throws RuntimeException {
        return this.visit((GeometryCollection)multiLine);
    }

    public Integer visit(MultiPoint multiPoint) throws RuntimeException {
        return multiPoint.size();
    }

    public Integer visit(MultiPolygon multiPolygon) throws RuntimeException {
        return this.visit((GeometryCollection)multiPolygon);
    }

    public Integer visit(Point point) throws RuntimeException {
        return 1;
    }

    public Integer visit(Polygon polygon) throws RuntimeException {
        int size = polygon.getPolygon().length();
        for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
            size += polygon.getHole(i).length();
        }
        return size;
    }

    public Integer visit(Rectangle rectangle) throws RuntimeException {
        return 4;
    }
}

