/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.matchers.source;

import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.sandbox.document.HalfFloatPoint;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.datageneration.matchers.MatchResult;
import org.elasticsearch.datageneration.matchers.Messages;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.xcontent.XContentBuilder;

interface FieldSpecificMatcher {
    public MatchResult match(List<Object> var1, List<Object> var2, Map<String, Object> var3, Map<String, Object> var4);

    public static Map<String, FieldSpecificMatcher> matchers(final XContentBuilder actualMappings, final Settings.Builder actualSettings, final XContentBuilder expectedMappings, final Settings.Builder expectedSettings) {
        return new HashMap<String, FieldSpecificMatcher>(){
            {
                this.put("keyword", new KeywordMatcher(actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("long", new NumberMatcher("long", actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("unsigned_long", new UnsignedLongMatcher(actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("integer", new NumberMatcher("integer", actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("short", new NumberMatcher("short", actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("byte", new NumberMatcher("byte", actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("double", new NumberMatcher("double", actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("float", new NumberMatcher("float", actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("half_float", new HalfFloatMatcher(actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("scaled_float", new ScaledFloatMatcher(actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("counted_keyword", new CountedKeywordMatcher(actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("boolean", new BooleanMatcher(actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("date", new DateMatcher(actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("geo_shape", new ExactMatcher("geo_shape", actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("shape", new ExactMatcher("shape", actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("geo_point", new GeoPointMatcher(actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("text", new TextMatcher(actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("ip", new IpMatcher(actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("constant_keyword", new ConstantKeywordMatcher(actualMappings, actualSettings, expectedMappings, expectedSettings));
                this.put("wildcard", new WildcardMatcher(actualMappings, actualSettings, expectedMappings, expectedSettings));
            }
        };
    }

    private static Object getNullValue(Map<String, Object> actualMapping, Map<String, Object> expectedMapping) {
        return FieldSpecificMatcher.getMappingParameter("null_value", actualMapping, expectedMapping);
    }

    private static Object getMappingParameter(String name, Map<String, Object> actualMapping, Map<String, Object> expectedMapping) {
        Object expectedValue;
        Object actualValue = actualMapping.get(name);
        if (!Objects.equals(actualValue, expectedValue = expectedMapping.get(name))) {
            throw new IllegalStateException("[" + name + "] parameter does not match between actual and expected mapping");
        }
        return actualValue;
    }

    public static abstract class GenericMappingAwareMatcher
    implements FieldSpecificMatcher {
        private final String fieldType;
        private final XContentBuilder actualMappings;
        private final Settings.Builder actualSettings;
        private final XContentBuilder expectedMappings;
        private final Settings.Builder expectedSettings;

        GenericMappingAwareMatcher(String fieldType, XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            this.fieldType = fieldType;
            this.actualMappings = actualMappings;
            this.actualSettings = actualSettings;
            this.expectedMappings = expectedMappings;
            this.expectedSettings = expectedSettings;
        }

        @Override
        public MatchResult match(List<Object> actual, List<Object> expected, Map<String, Object> actualMapping, Map<String, Object> expectedMapping) {
            Object nullValue = FieldSpecificMatcher.getNullValue(actualMapping, expectedMapping);
            Set<Object> expectedNormalized = this.normalize(expected, nullValue);
            Set<Object> actualNormalized = this.normalize(actual, nullValue);
            return actualNormalized.equals(expectedNormalized) ? MatchResult.match() : MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Values of type [" + this.fieldType + "] don't match after normalization, normalized " + Messages.prettyPrintCollections(actualNormalized, expectedNormalized)));
        }

        private Set<Object> normalize(List<Object> values, Object nullValue) {
            if (values == null) {
                return Set.of();
            }
            return values.stream().map(v -> this.convert(v, nullValue)).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        abstract Object convert(Object var1, Object var2);
    }

    public static class WildcardMatcher
    extends GenericMappingAwareMatcher {
        WildcardMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            super("wildcard", actualMappings, actualSettings, expectedMappings, expectedSettings);
        }

        @Override
        Object convert(Object value, Object nullValue) {
            if (value == null) {
                if (nullValue != null) {
                    return nullValue;
                }
                return null;
            }
            return value;
        }
    }

    public static class ConstantKeywordMatcher
    extends GenericMappingAwareMatcher {
        ConstantKeywordMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            super("constant_keyword", actualMappings, actualSettings, expectedMappings, expectedSettings);
        }

        @Override
        Object convert(Object value, Object nullValue) {
            return value;
        }
    }

    public static class IpMatcher
    extends GenericMappingAwareMatcher {
        IpMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            super("ip", actualMappings, actualSettings, expectedMappings, expectedSettings);
        }

        @Override
        Object convert(Object value, Object nullValue) {
            if (value == null) {
                if (nullValue != null) {
                    return nullValue;
                }
                return null;
            }
            return value;
        }
    }

    public static class TextMatcher
    implements FieldSpecificMatcher {
        private final XContentBuilder actualMappings;
        private final Settings.Builder actualSettings;
        private final XContentBuilder expectedMappings;
        private final Settings.Builder expectedSettings;

        TextMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            this.actualMappings = actualMappings;
            this.actualSettings = actualSettings;
            this.expectedMappings = expectedMappings;
            this.expectedSettings = expectedSettings;
        }

        @Override
        public MatchResult match(List<Object> actual, List<Object> expected, Map<String, Object> actualMapping, Map<String, Object> expectedMapping) {
            Map keywordFieldMapping;
            KeywordMatcher keywordMatcher;
            MatchResult keywordMatchResult;
            Set<Object> expectedNormalized = this.normalize(expected);
            Set<Object> actualNormalized = this.normalize(actual);
            if (actualNormalized.equals(expectedNormalized)) {
                return MatchResult.match();
            }
            Map multiFields = (Map)FieldSpecificMatcher.getMappingParameter("fields", actualMapping, expectedMapping);
            if (multiFields != null && (keywordMatchResult = (keywordMatcher = new KeywordMatcher(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings)).match(actual, expected, keywordFieldMapping = (Map)multiFields.get("kwd"), keywordFieldMapping)).isMatch()) {
                return MatchResult.match();
            }
            return MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Values of type [text] don't match, " + Messages.prettyPrintCollections(actual, expected)));
        }

        private Set<Object> normalize(List<Object> values) {
            if (values == null) {
                return Set.of();
            }
            return values.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        }
    }

    public static class ExactMatcher
    implements FieldSpecificMatcher {
        private final String fieldType;
        private final XContentBuilder actualMappings;
        private final Settings.Builder actualSettings;
        private final XContentBuilder expectedMappings;
        private final Settings.Builder expectedSettings;

        ExactMatcher(String fieldType, XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            this.fieldType = fieldType;
            this.actualMappings = actualMappings;
            this.actualSettings = actualSettings;
            this.expectedMappings = expectedMappings;
            this.expectedSettings = expectedSettings;
        }

        @Override
        public MatchResult match(List<Object> actual, List<Object> expected, Map<String, Object> actualMapping, Map<String, Object> expectedMapping) {
            return actual.equals(expected) ? MatchResult.match() : MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Values of type [" + this.fieldType + "] were expected to match exactly but don't match, values " + Messages.prettyPrintCollections(actual, expected)));
        }
    }

    public static class GeoPointMatcher
    extends GenericMappingAwareMatcher {
        GeoPointMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            super("geo_point", actualMappings, actualSettings, expectedMappings, expectedSettings);
        }

        @Override
        Object convert(Object value, Object nullValue) {
            if (value == null) {
                if (nullValue != null) {
                    return GeoPointMatcher.normalizePoint(new GeoPoint((String)nullValue));
                }
                return null;
            }
            if (value instanceof String) {
                String s = (String)value;
                try {
                    return GeoPointMatcher.normalizePoint(new GeoPoint(s));
                }
                catch (Exception e) {
                    return value;
                }
            }
            if (value instanceof Map) {
                Map m = (Map)value;
                if (m.get("type") != null) {
                    List coordinates = (List)m.get("coordinates");
                    return GeoPointMatcher.normalizePoint(new GeoPoint(((Double)coordinates.get(1)).doubleValue(), ((Double)coordinates.get(0)).doubleValue()));
                }
                return GeoPointMatcher.normalizePoint(new GeoPoint(((Double)m.get("lat")).doubleValue(), ((Double)m.get("lon")).doubleValue()));
            }
            if (value instanceof List) {
                List l = (List)value;
                return GeoPointMatcher.normalizePoint(new GeoPoint(((Double)l.get(1)).doubleValue(), ((Double)l.get(0)).doubleValue()));
            }
            return value;
        }

        private static GeoPoint normalizePoint(GeoPoint point) {
            return point.resetFromEncoded(point.getEncoded());
        }
    }

    public static class DateMatcher
    implements FieldSpecificMatcher {
        private final XContentBuilder actualMappings;
        private final Settings.Builder actualSettings;
        private final XContentBuilder expectedMappings;
        private final Settings.Builder expectedSettings;

        DateMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            this.actualMappings = actualMappings;
            this.actualSettings = actualSettings;
            this.expectedMappings = expectedMappings;
            this.expectedSettings = expectedSettings;
        }

        @Override
        public MatchResult match(List<Object> actual, List<Object> expected, Map<String, Object> actualMapping, Map<String, Object> expectedMapping) {
            Set<Object> expectedNormalized;
            Set<Object> actualNormalized;
            String format = (String)FieldSpecificMatcher.getMappingParameter("format", actualMapping, expectedMapping);
            Object nullValue = FieldSpecificMatcher.getNullValue(actualMapping, expectedMapping);
            Function<Object, Object> convert = v -> this.convert(v, nullValue);
            if (format != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format, Locale.ROOT).withZone(ZoneId.from(ZoneOffset.UTC));
                convert = v -> this.convert(v, nullValue, formatter);
            }
            return (actualNormalized = this.normalize(actual, convert)).equals(expectedNormalized = this.normalize(expected, convert)) ? MatchResult.match() : MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Values of type [date] don't match after normalization, normalized " + Messages.prettyPrintCollections(actualNormalized, expectedNormalized)));
        }

        private Set<Object> normalize(List<Object> values, Function<Object, Object> convert) {
            if (values == null) {
                return Set.of();
            }
            return values.stream().map(convert).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        Object convert(Object value, Object nullValue) {
            if (value == null) {
                return nullValue == null ? null : Instant.ofEpochMilli((Long)nullValue);
            }
            if (value instanceof Integer) {
                Integer i = (Integer)value;
                return Instant.ofEpochMilli(i.intValue());
            }
            if (value instanceof Long) {
                Long l = (Long)value;
                return Instant.ofEpochMilli(l);
            }
            assert (value instanceof String);
            try {
                return Instant.from(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.parse((String)value));
            }
            catch (Exception e) {
                return value;
            }
        }

        Object convert(Object value, Object nullValue, DateTimeFormatter dateTimeFormatter) {
            if (value == null) {
                return nullValue == null ? null : Long.valueOf(Instant.from(dateTimeFormatter.parse((String)nullValue)).toEpochMilli());
            }
            assert (value instanceof String);
            try {
                return Instant.from(dateTimeFormatter.parse((String)value)).toEpochMilli();
            }
            catch (Exception e) {
                return value;
            }
        }
    }

    public static class BooleanMatcher
    extends GenericMappingAwareMatcher {
        BooleanMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            super("boolean", actualMappings, actualSettings, expectedMappings, expectedSettings);
        }

        @Override
        Object convert(Object value, Object nullValue) {
            String s;
            Boolean nullValueBool = null;
            if (nullValue != null) {
                Boolean b;
                Boolean bl = nullValueBool = nullValue instanceof Boolean ? (b = (Boolean)nullValue) : Boolean.valueOf(Boolean.parseBoolean((String)nullValue));
            }
            if (value == null) {
                return nullValueBool;
            }
            if (value instanceof String && (s = (String)value).isEmpty()) {
                return false;
            }
            if (value instanceof String) {
                s = (String)value;
                try {
                    return Boolean.parseBoolean(s);
                }
                catch (Exception e) {
                    return value;
                }
            }
            return value;
        }
    }

    public static class NumberMatcher
    extends GenericMappingAwareMatcher {
        NumberMatcher(String fieldType, XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            super(fieldType, actualMappings, actualSettings, expectedMappings, expectedSettings);
        }

        @Override
        Object convert(Object value, Object nullValue) {
            String s;
            if (value == null) {
                return nullValue;
            }
            if (value instanceof String && (s = (String)value).isEmpty()) {
                return nullValue;
            }
            return value;
        }
    }

    public static class KeywordMatcher
    extends GenericMappingAwareMatcher {
        KeywordMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            super("keyword", actualMappings, actualSettings, expectedMappings, expectedSettings);
        }

        @Override
        Object convert(Object value, Object nullValue) {
            if (value == null) {
                return nullValue;
            }
            return value;
        }
    }

    public static class UnsignedLongMatcher
    extends GenericMappingAwareMatcher {
        UnsignedLongMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            super("unsigned_long", actualMappings, actualSettings, expectedMappings, expectedSettings);
        }

        @Override
        Object convert(Object value, Object nullValue) {
            BigInteger nullValueBigInt = nullValue != null ? BigInteger.valueOf(((Number)nullValue).longValue()) : null;
            Object object = value;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Long.class}, (Object)object, n)) {
                case -1 -> nullValueBigInt;
                case 0 -> {
                    String s = (String)object;
                    if (s.isEmpty()) {
                        yield nullValueBigInt;
                    }
                    yield s;
                }
                case 1 -> {
                    Long l = (Long)object;
                    yield BigInteger.valueOf(l);
                }
                default -> value;
            };
        }
    }

    public static class ScaledFloatMatcher
    implements FieldSpecificMatcher {
        private final XContentBuilder actualMappings;
        private final Settings.Builder actualSettings;
        private final XContentBuilder expectedMappings;
        private final Settings.Builder expectedSettings;

        ScaledFloatMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            this.actualMappings = actualMappings;
            this.actualSettings = actualSettings;
            this.expectedMappings = expectedMappings;
            this.expectedSettings = expectedSettings;
        }

        @Override
        public MatchResult match(List<Object> actual, List<Object> expected, Map<String, Object> actualMapping, Map<String, Object> expectedMapping) {
            Object scalingFactor = FieldSpecificMatcher.getMappingParameter("scaling_factor", actualMapping, expectedMapping);
            assert (scalingFactor instanceof Number);
            double scalingFactorDouble = ((Number)scalingFactor).doubleValue();
            Number nullValue = (Number)FieldSpecificMatcher.getNullValue(actualMapping, expectedMapping);
            Set<Double> expectedNumbers = this.numbers(expected, nullValue);
            Set<Double> actualNumbers = this.numbers(actual, nullValue);
            for (Double expectedValue : expectedNumbers) {
                if (actualNumbers.contains(expectedValue) || actualNumbers.contains(this.encodeDecodeWithPrecisionLoss(expectedValue, scalingFactorDouble))) continue;
                return MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Values of type [scaled_float] don't match after normalization, normalized " + Messages.prettyPrintCollections(actualNumbers, expectedNumbers)));
            }
            Set<Object> expectedNotNumbers = this.notNumbers(expected);
            Set<Object> actualNotNumbers = this.notNumbers(actual);
            for (Object expectedValue : expectedNotNumbers) {
                if (actualNotNumbers.contains(expectedValue)) continue;
                return MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Malformed values of [scaled_float] field don't match, values:" + Messages.prettyPrintCollections(actualNotNumbers, expectedNotNumbers)));
            }
            return MatchResult.match();
        }

        private Set<Double> numbers(List<Object> values, Number nullValue) {
            if (values == null) {
                return Set.of();
            }
            return values.stream().map(v -> ScaledFloatMatcher.convertNumber(v, nullValue)).filter(Objects::nonNull).map(ScaledFloatMatcher::toDouble).collect(Collectors.toSet());
        }

        private static Object convertNumber(Object value, Number nullValue) {
            String s;
            if (value == null) {
                return nullValue;
            }
            if (value instanceof String && (s = (String)value).isEmpty()) {
                return nullValue;
            }
            if (value instanceof Number) {
                Number n = (Number)value;
                return n;
            }
            return null;
        }

        private Set<Object> notNumbers(List<Object> values) {
            if (values == null) {
                return Set.of();
            }
            return values.stream().filter(Objects::nonNull).filter(v -> !(v instanceof Number)).filter(v -> !(v instanceof String) || !((String)v).isEmpty()).collect(Collectors.toSet());
        }

        private Double encodeDecodeWithPrecisionLoss(double value, double scalingFactor) {
            long encoded = Math.round(value * scalingFactor);
            return (double)encoded / scalingFactor;
        }

        private static double toDouble(Object value) {
            return ((Number)value).doubleValue();
        }
    }

    public static class HalfFloatMatcher
    extends GenericMappingAwareMatcher {
        HalfFloatMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            super("half_float", actualMappings, actualSettings, expectedMappings, expectedSettings);
        }

        @Override
        Object convert(Object value, Object nullValue) {
            Short nullValueShort = nullValue != null ? Short.valueOf(HalfFloatPoint.halfFloatToSortableShort((float)((Number)nullValue).floatValue())) : null;
            Object object = value;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
                case -1 -> {
                    Short var6_6 = nullValueShort;
                    yield var6_6;
                }
                case 0 -> {
                    Number n = (Number)object;
                    Short var6_7 = HalfFloatPoint.halfFloatToSortableShort((float)n.floatValue());
                    yield var6_7;
                }
                case 1 -> {
                    String s = (String)object;
                    if (s.isEmpty()) {
                        Short var6_8 = nullValueShort;
                        yield var6_8;
                    }
                    try {
                        float f = Float.parseFloat(s);
                        Short var6_9 = HalfFloatPoint.halfFloatToSortableShort((float)f);
                        yield var6_9;
                    }
                    catch (NumberFormatException e) {
                        String var6_10 = s;
                        yield var6_10;
                    }
                }
                default -> {
                    Object var6_11;
                    yield var6_11 = value;
                }
            };
        }
    }

    public static class CountedKeywordMatcher
    implements FieldSpecificMatcher {
        private final XContentBuilder actualMappings;
        private final Settings.Builder actualSettings;
        private final XContentBuilder expectedMappings;
        private final Settings.Builder expectedSettings;

        CountedKeywordMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings) {
            this.actualMappings = actualMappings;
            this.actualSettings = actualSettings;
            this.expectedMappings = expectedMappings;
            this.expectedSettings = expectedSettings;
        }

        @Override
        public MatchResult match(List<Object> actual, List<Object> expected, Map<String, Object> actualMapping, Map<String, Object> expectedMapping) {
            List<String> actualNormalized = CountedKeywordMatcher.normalize(actual);
            List<String> expectedNormalized = CountedKeywordMatcher.normalize(expected);
            TreeMap<String, Integer> counts = new TreeMap<String, Integer>();
            for (String value : actualNormalized) {
                counts.put(value, counts.getOrDefault(value, 0) + 1);
            }
            for (String value : expectedNormalized) {
                int newCount = counts.getOrDefault(value, 0) - 1;
                if (newCount == 0) {
                    counts.remove(value);
                    continue;
                }
                counts.put(value, newCount);
            }
            if (!counts.isEmpty()) {
                StringBuilder extraValuesMessage = new StringBuilder("extra values: ");
                for (Map.Entry entry : counts.entrySet()) {
                    extraValuesMessage.append('\n').append((String)entry.getKey()).append(": ").append(entry.getValue());
                }
                return MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Values of type [counted_keyword] don't match, " + String.valueOf(extraValuesMessage) + ".\n" + Messages.prettyPrintCollections(actualNormalized, expectedNormalized)));
            }
            return MatchResult.match();
        }

        private static List<String> normalize(List<Object> values) {
            return values.stream().filter(Objects::nonNull).map(it -> (String)it).toList();
        }
    }
}

