/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.fields.leaf;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.datageneration.FieldDataGenerator;
import org.elasticsearch.datageneration.datasource.DataSource;
import org.elasticsearch.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.datageneration.fields.leaf.Wrappers;

public class DateFieldDataGenerator
implements FieldDataGenerator {
    private final DataSource dataSource;
    private final Supplier<Instant> instants;
    private final Supplier<String> strings;

    public DateFieldDataGenerator(DataSource dataSource) {
        this.dataSource = dataSource;
        this.instants = () -> dataSource.get(new DataSourceRequest.InstantGenerator()).generator().get();
        this.strings = dataSource.get(new DataSourceRequest.StringGenerator()).generator();
    }

    @Override
    public Object generateValue(Map<String, Object> fieldMapping) {
        Supplier<Object> supplier = () -> this.instants.get().toEpochMilli();
        if (fieldMapping != null && fieldMapping.get("format") != null) {
            String format = (String)fieldMapping.get("format");
            supplier = () -> DateTimeFormatter.ofPattern(format, Locale.ROOT).withZone(ZoneId.from(ZoneOffset.UTC)).format(this.instants.get());
        }
        supplier = fieldMapping != null && ((Boolean)fieldMapping.getOrDefault("ignore_malformed", false)).booleanValue() ? Wrappers.defaultsWithMalformed(supplier, this.strings::get, this.dataSource) : Wrappers.defaults(supplier, this.dataSource);
        return supplier.get();
    }
}

