/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.Collection;
import java.util.NavigableMap;
import java.util.function.Predicate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.Maps;

public class TestLoggers {
    static NavigableMap<String, Level> getLogLevels() {
        Configuration config = LoggerContext.getContext((boolean)false).getConfiguration();
        return TestLoggers.getLogLevels(config.getLoggers().values());
    }

    private static NavigableMap<String, Level> getLogLevels(Collection<LoggerConfig> configs) {
        return (NavigableMap)configs.stream().collect(Maps.toUnmodifiableSortedMap(LoggerConfig::getName, LoggerConfig::getLevel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithLoggersRestored(Runnable task) {
        Configuration config = LoggerContext.getContext((boolean)false).getConfiguration();
        Collection<LoggerConfig> configs = config.getLoggers().values();
        NavigableMap<String, Level> levels = TestLoggers.getLogLevels(configs);
        try {
            task.run();
        }
        finally {
            configs.stream().map(LoggerConfig::getName).filter(Predicate.not(levels::containsKey)).forEach(arg_0 -> ((Configuration)config).removeLogger(arg_0));
            levels.forEach((logger, level) -> Loggers.setLevel((Logger)LogManager.getLogger((String)logger), (Level)level));
        }
    }
}

