/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.stream.Stream;
import org.elasticsearch.common.logging.JsonLogLine;
import org.elasticsearch.common.logging.JsonLogsStream;
import org.elasticsearch.test.rest.ESRestTestCase;
import org.elasticsearch.xcontent.ObjectParser;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class JsonLogsIntegTestCase
extends ESRestTestCase {
    private static final int LINES_TO_CHECK = 10;

    protected abstract Matcher<String> nodeNameMatcher();

    private BufferedReader openReader() {
        return new BufferedReader(new InputStreamReader(this.openLogsStream(), StandardCharsets.UTF_8));
    }

    protected abstract InputStream openLogsStream();

    public void testElementsPresentOnAllLinesOfLog() throws IOException {
        JsonLogLine firstLine = this.findFirstLine();
        JsonLogsIntegTestCase.assertNotNull((Object)firstLine);
        try (Stream<JsonLogLine> stream = JsonLogsStream.from(this.openReader(), this.getParser());){
            stream.limit(10L).forEach(jsonLogLine -> {
                JsonLogsIntegTestCase.assertThat(jsonLogLine.getDataset(), Matchers.is((Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString())));
                JsonLogsIntegTestCase.assertThat(jsonLogLine.getTimestamp(), Matchers.is((Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString())));
                JsonLogsIntegTestCase.assertThat(jsonLogLine.getLevel(), Matchers.is((Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString())));
                JsonLogsIntegTestCase.assertThat(jsonLogLine.getComponent(), Matchers.is((Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString())));
                JsonLogsIntegTestCase.assertThat(jsonLogLine.getMessage(), Matchers.is((Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString())));
                JsonLogsIntegTestCase.assertThat(jsonLogLine.getNodeName(), this.nodeNameMatcher());
                JsonLogsIntegTestCase.assertThat(jsonLogLine.getClusterName(), Matchers.equalTo((Object)firstLine.getClusterName()));
            });
        }
    }

    private JsonLogLine findFirstLine() throws IOException {
        try (Stream<JsonLogLine> stream = JsonLogsStream.from(this.openReader(), this.getParser());){
            JsonLogLine jsonLogLine = stream.findFirst().orElseThrow(() -> new AssertionError((Object)"no logs at all?!"));
            return jsonLogLine;
        }
    }

    public void testNodeIdAndClusterIdConsistentOnceAvailable() throws IOException {
        try (Stream<JsonLogLine> stream = JsonLogsStream.from(this.openReader(), this.getParser());){
            Iterator iterator = stream.iterator();
            JsonLogLine firstLine = null;
            while (iterator.hasNext()) {
                JsonLogLine jsonLogLine = (JsonLogLine)iterator.next();
                if (jsonLogLine.getNodeId() == null) continue;
                firstLine = jsonLogLine;
                break;
            }
            JsonLogsIntegTestCase.assertNotNull(firstLine);
            int i = 0;
            while (iterator.hasNext() && i++ < 10) {
                JsonLogLine jsonLogLine = (JsonLogLine)iterator.next();
                JsonLogsIntegTestCase.assertThat(jsonLogLine.getNodeId(), Matchers.equalTo((Object)firstLine.getNodeId()));
                JsonLogsIntegTestCase.assertThat(jsonLogLine.getClusterUuid(), Matchers.equalTo((Object)firstLine.getClusterUuid()));
            }
        }
    }

    protected ObjectParser<JsonLogLine, Void> getParser() {
        return JsonLogLine.ECS_LOG_LINE;
    }
}

