/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStatePublicationEvent;
import org.elasticsearch.cluster.coordination.ClusterStatePublisher;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.StoppableExecutorServiceWrapper;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.node.Node;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;

public class FakeThreadPoolMasterService
extends MasterService {
    private final Consumer<Runnable> taskExecutor;
    private final ThreadContext threadContext;

    public FakeThreadPoolMasterService(String nodeName, ThreadPool threadPool, Consumer<Runnable> taskExecutor) {
        this(Settings.builder().put(Node.NODE_NAME_SETTING.getKey(), nodeName).build(), new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS), threadPool, taskExecutor);
    }

    private FakeThreadPoolMasterService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool, Consumer<Runnable> taskExecutor) {
        super(settings, clusterSettings, threadPool, new TaskManager(settings, threadPool, Set.of()));
        this.taskExecutor = taskExecutor;
        this.threadContext = threadPool.getThreadContext();
    }

    protected ExecutorService createThreadPoolExecutor() {
        return new StoppableExecutorServiceWrapper(EsExecutors.DIRECT_EXECUTOR_SERVICE){

            @Override
            public void execute(Runnable command) {
                FakeThreadPoolMasterService.this.taskExecutor.accept(FakeThreadPoolMasterService.this.threadContext.preserveContext(command));
            }

            public String toString() {
                return "FakeThreadPoolMasterService executor";
            }
        };
    }

    public ClusterState.Builder incrementVersion(ClusterState clusterState) {
        return ClusterState.builder((ClusterState)clusterState).incrementVersion().stateUUID(UUIDs.randomBase64UUID((Random)LuceneTestCase.random()));
    }

    protected void publish(final ClusterStatePublicationEvent clusterStatePublicationEvent, final ClusterStatePublisher.AckListener ackListener, final ActionListener<Void> publicationListener) {
        this.taskExecutor.accept(this.threadPool.getThreadContext().preserveContext(new Runnable(){

            @Override
            public void run() {
                FakeThreadPoolMasterService.super.publish(clusterStatePublicationEvent, FakeThreadPoolMasterService.this.wrapAckListener(ackListener), publicationListener);
            }

            public String toString() {
                return "publish change of cluster state from version [" + clusterStatePublicationEvent.getOldState().version() + "] in term [" + clusterStatePublicationEvent.getOldState().term() + "] to version [" + clusterStatePublicationEvent.getNewState().version() + "] in term [" + clusterStatePublicationEvent.getNewState().term() + "]";
            }
        }));
    }

    protected ClusterStatePublisher.AckListener wrapAckListener(ClusterStatePublisher.AckListener ackListener) {
        return ackListener;
    }
}

