/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.TimeSeriesParams;

public class IndexFieldCapabilitiesBuilder {
    private final String name;
    private final String type;
    private boolean isMetadataField;
    private boolean isSearchable;
    private boolean isAggregatable;
    private boolean isDimension;
    @Nullable
    private TimeSeriesParams.MetricType metricType;
    private Map<String, String> meta;

    public IndexFieldCapabilitiesBuilder(String name, String type) {
        this.name = name;
        this.type = type;
        this.isSearchable = true;
        this.isAggregatable = true;
        this.meta = Collections.emptyMap();
    }

    public IndexFieldCapabilitiesBuilder isMetadataField(boolean isMetadataField) {
        this.isMetadataField = isMetadataField;
        return this;
    }

    public IndexFieldCapabilitiesBuilder isSearchable(boolean isSearchable) {
        this.isSearchable = isSearchable;
        return this;
    }

    public IndexFieldCapabilitiesBuilder isAggregatable(boolean isAggregatable) {
        this.isAggregatable = isAggregatable;
        return this;
    }

    public IndexFieldCapabilitiesBuilder isDimension(boolean isDimension) {
        this.isDimension = isDimension;
        return this;
    }

    public IndexFieldCapabilitiesBuilder metricType(TimeSeriesParams.MetricType metricType) {
        this.metricType = metricType;
        return this;
    }

    public IndexFieldCapabilitiesBuilder meta(@Nullable Map<String, String> meta) {
        this.meta = meta != null ? new TreeMap<String, String>(meta) : null;
        return this;
    }

    public IndexFieldCapabilities build() {
        return new IndexFieldCapabilities(this.name, this.type, this.isMetadataField, this.isSearchable, this.isAggregatable, this.isDimension, this.metricType, this.meta);
    }
}

