/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geometry.simplify;

public class SloppyMath {
    private static final double TO_METERS = 6371008.7714;
    private static final double ONE_DIV_F2 = 0.5;
    private static final double ONE_DIV_F3 = 0.16666666666666666;
    private static final double ONE_DIV_F4 = 0.041666666666666664;
    private static final double PIO2_HI;
    private static final double PIO2_LO;
    private static final double TWOPI_HI;
    private static final double TWOPI_LO;
    private static final int SIN_COS_TABS_SIZE = 2049;
    private static final double SIN_COS_DELTA_HI;
    private static final double SIN_COS_DELTA_LO;
    private static final double SIN_COS_INDEXER;
    private static final double[] sinTab;
    private static final double[] cosTab;
    static final double SIN_COS_MAX_VALUE_FOR_INT_MODULO;
    private static final double ASIN_MAX_VALUE_FOR_TABS;
    private static final int ASIN_TABS_SIZE = 8193;
    private static final double ASIN_DELTA;
    private static final double ASIN_INDEXER;
    private static final double[] asinTab;
    private static final double[] asinDer1DivF1Tab;
    private static final double[] asinDer2DivF2Tab;
    private static final double[] asinDer3DivF3Tab;
    private static final double[] asinDer4DivF4Tab;
    private static final double ASIN_PIO2_HI;
    private static final double ASIN_PIO2_LO;
    private static final double ASIN_PS0;
    private static final double ASIN_PS1;
    private static final double ASIN_PS2;
    private static final double ASIN_PS3;
    private static final double ASIN_PS4;
    private static final double ASIN_PS5;
    private static final double ASIN_QS1;
    private static final double ASIN_QS2;
    private static final double ASIN_QS3;
    private static final double ASIN_QS4;

    public static double haversinMeters(double lat1, double lon1, double lat2, double lon2) {
        return SloppyMath.haversinMeters(SloppyMath.haversinSortKey(lat1, lon1, lat2, lon2));
    }

    public static double haversinMeters(double sortKey) {
        return 1.27420175428E7 * SloppyMath.asin(Math.min(1.0, Math.sqrt(sortKey * 0.5)));
    }

    public static double haversinSortKey(double lat1, double lon1, double lat2, double lon2) {
        double x1 = Math.toRadians(lat1);
        double x2 = Math.toRadians(lat2);
        double h1 = 1.0 - SloppyMath.cos(x1 - x2);
        double h2 = 1.0 - SloppyMath.cos(Math.toRadians(lon1 - lon2));
        double h = h1 + SloppyMath.cos(x1) * SloppyMath.cos(x2) * h2;
        return Double.longBitsToDouble(Double.doubleToRawLongBits(h) & 0xFFFFFFFFFFFFFFF8L);
    }

    public static double cos(double a) {
        if (a < 0.0) {
            a = -a;
        }
        if (a > SIN_COS_MAX_VALUE_FOR_INT_MODULO) {
            return Math.cos(a);
        }
        int index = (int)(a * SIN_COS_INDEXER + 0.5);
        double delta = a - (double)index * SIN_COS_DELTA_HI - (double)index * SIN_COS_DELTA_LO;
        double indexCos = cosTab[index &= 0x7FF];
        double indexSin = sinTab[index];
        return indexCos + delta * (-indexSin + delta * (-indexCos * 0.5 + delta * (indexSin * 0.16666666666666666 + delta * indexCos * 0.041666666666666664)));
    }

    public static double asin(double a) {
        boolean negateResult;
        if (a < 0.0) {
            a = -a;
            negateResult = true;
        } else {
            negateResult = false;
        }
        if (a <= ASIN_MAX_VALUE_FOR_TABS) {
            int index = (int)(a * ASIN_INDEXER + 0.5);
            double delta = a - (double)index * ASIN_DELTA;
            double result = asinTab[index] + delta * (asinDer1DivF1Tab[index] + delta * (asinDer2DivF2Tab[index] + delta * (asinDer3DivF3Tab[index] + delta * asinDer4DivF4Tab[index])));
            return negateResult ? -result : result;
        }
        if (a < 1.0) {
            double t = (1.0 - a) * 0.5;
            double p = t * (ASIN_PS0 + t * (ASIN_PS1 + t * (ASIN_PS2 + t * (ASIN_PS3 + t * (ASIN_PS4 + t * ASIN_PS5)))));
            double q = 1.0 + t * (ASIN_QS1 + t * (ASIN_QS2 + t * (ASIN_QS3 + t * ASIN_QS4)));
            double s = Math.sqrt(t);
            double z = s + s * (p / q);
            double result = ASIN_PIO2_HI - (z + z - ASIN_PIO2_LO);
            return negateResult ? -result : result;
        }
        if (a == 1.0) {
            return negateResult ? -1.5707963267948966 : 1.5707963267948966;
        }
        return Double.NaN;
    }

    static {
        int i;
        PIO2_HI = Double.longBitsToDouble(4609753056924401664L);
        PIO2_LO = Double.longBitsToDouble(4454258360616903473L);
        TWOPI_HI = 4.0 * PIO2_HI;
        TWOPI_LO = 4.0 * PIO2_LO;
        SIN_COS_DELTA_HI = TWOPI_HI / 2048.0;
        SIN_COS_DELTA_LO = TWOPI_LO / 2048.0;
        SIN_COS_INDEXER = 1.0 / (SIN_COS_DELTA_HI + SIN_COS_DELTA_LO);
        sinTab = new double[2049];
        cosTab = new double[2049];
        SIN_COS_MAX_VALUE_FOR_INT_MODULO = 4194303.0 / SIN_COS_INDEXER * 0.99;
        ASIN_MAX_VALUE_FOR_TABS = StrictMath.sin(Math.toRadians(73.0));
        ASIN_DELTA = ASIN_MAX_VALUE_FOR_TABS / 8192.0;
        ASIN_INDEXER = 1.0 / ASIN_DELTA;
        asinTab = new double[8193];
        asinDer1DivF1Tab = new double[8193];
        asinDer2DivF2Tab = new double[8193];
        asinDer3DivF3Tab = new double[8193];
        asinDer4DivF4Tab = new double[8193];
        ASIN_PIO2_HI = Double.longBitsToDouble(4609753056924675352L);
        ASIN_PIO2_LO = Double.longBitsToDouble(4364452196894661639L);
        ASIN_PS0 = Double.longBitsToDouble(4595172819793696085L);
        ASIN_PS1 = Double.longBitsToDouble(-4623835544539140227L);
        ASIN_PS2 = Double.longBitsToDouble(4596417465768494165L);
        ASIN_PS3 = Double.longBitsToDouble(-4637438604930937029L);
        ASIN_PS4 = Double.longBitsToDouble(4560439845004096136L);
        ASIN_PS5 = Double.longBitsToDouble(4540259411154564873L);
        ASIN_QS1 = Double.longBitsToDouble(-4610777653840302773L);
        ASIN_QS2 = Double.longBitsToDouble(4611733184086379208L);
        ASIN_QS3 = Double.longBitsToDouble(-4618997306433404583L);
        ASIN_QS4 = Double.longBitsToDouble(4590215604441354882L);
        int SIN_COS_PI_INDEX = 1024;
        int SIN_COS_PI_MUL_2_INDEX = 2048;
        int SIN_COS_PI_MUL_0_5_INDEX = 512;
        int SIN_COS_PI_MUL_1_5_INDEX = 1536;
        for (i = 0; i < 2049; ++i) {
            double angle = (double)i * SIN_COS_DELTA_HI + (double)i * SIN_COS_DELTA_LO;
            double sinAngle = StrictMath.sin(angle);
            double cosAngle = StrictMath.cos(angle);
            if (i == 1024) {
                sinAngle = 0.0;
            } else if (i == 2048) {
                sinAngle = 0.0;
            } else if (i == 512) {
                cosAngle = 0.0;
            } else if (i == 1536) {
                cosAngle = 0.0;
            }
            SloppyMath.sinTab[i] = sinAngle;
            SloppyMath.cosTab[i] = cosAngle;
        }
        for (i = 0; i < 8193; ++i) {
            double x = (double)i * ASIN_DELTA;
            SloppyMath.asinTab[i] = StrictMath.asin(x);
            double oneMinusXSqInv = 1.0 / (1.0 - x * x);
            double oneMinusXSqInv0_5 = StrictMath.sqrt(oneMinusXSqInv);
            double oneMinusXSqInv1_5 = oneMinusXSqInv0_5 * oneMinusXSqInv;
            double oneMinusXSqInv2_5 = oneMinusXSqInv1_5 * oneMinusXSqInv;
            double oneMinusXSqInv3_5 = oneMinusXSqInv2_5 * oneMinusXSqInv;
            SloppyMath.asinDer1DivF1Tab[i] = oneMinusXSqInv0_5;
            SloppyMath.asinDer2DivF2Tab[i] = x * oneMinusXSqInv1_5 * 0.5;
            SloppyMath.asinDer3DivF3Tab[i] = (1.0 + 2.0 * x * x) * oneMinusXSqInv2_5 * 0.16666666666666666;
            SloppyMath.asinDer4DivF4Tab[i] = (5.0 + 2.0 * x * (2.0 + x * (5.0 - 2.0 * x))) * oneMinusXSqInv3_5 * 0.041666666666666664;
        }
    }
}

