/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.index.mapper.MappedFieldType;

public class FieldLookup {
    private final MappedFieldType fieldType;
    private final List<Object> values = new ArrayList<Object>();
    private boolean valuesLoaded = false;

    public FieldLookup(MappedFieldType fieldType) {
        this.fieldType = fieldType;
    }

    public MappedFieldType fieldType() {
        return this.fieldType;
    }

    public void setValues(List<Object> values) {
        assert (!this.valuesLoaded) : "Call clear() before calling setValues()";
        if (values != null) {
            values.stream().map(this.fieldType::valueForDisplay).forEach(this.values::add);
        }
        this.valuesLoaded = true;
    }

    public boolean isLoaded() {
        return this.valuesLoaded;
    }

    public void clear() {
        this.values.clear();
        this.valuesLoaded = false;
    }

    public List<Object> getValues() {
        assert (this.valuesLoaded);
        return this.values;
    }

    public Object getValue() {
        assert (this.valuesLoaded);
        return this.values.isEmpty() ? null : this.values.get(0);
    }

    public boolean isEmpty() {
        assert (this.valuesLoaded);
        return this.values.isEmpty();
    }
}

