/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.Build;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.SuppressForbidden;

public final class ReferenceDocs
extends Enum<ReferenceDocs> {
    public static final /* enum */ ReferenceDocs INITIAL_MASTER_NODES = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs DISCOVERY_TROUBLESHOOTING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs UNSTABLE_CLUSTER_TROUBLESHOOTING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs LAGGING_NODE_TROUBLESHOOTING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs SHARD_LOCK_TROUBLESHOOTING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs NETWORK_DISCONNECT_TROUBLESHOOTING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs CONCURRENT_REPOSITORY_WRITERS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs ARCHIVE_INDICES = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs HTTP_TRACER = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs LOGGING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_HEAP_SIZE = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_FILE_DESCRIPTOR = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_MEMORY_LOCK = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_MAX_NUMBER_THREADS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_MAX_FILE_SIZE = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_MAX_SIZE_VIRTUAL_MEMORY = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_MAXIMUM_MAP_COUNT = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_CLIENT_JVM = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_USE_SERIAL_COLLECTOR = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_SYSTEM_CALL_FILTER = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_ONERROR_AND_ONOUTOFMEMORYERROR = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_EARLY_ACCESS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_ALL_PERMISSION = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_DISCOVERY_CONFIGURATION = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECKS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_ENCRYPT_SENSITIVE_DATA = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_PKI_REALM = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_ROLE_MAPPINGS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_TLS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs BOOTSTRAP_CHECK_TOKEN_SSL = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs CONTACT_SUPPORT = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs UNASSIGNED_SHARDS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs EXECUTABLE_JNA_TMPDIR = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs NETWORK_THREADING_MODEL = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs ALLOCATION_EXPLAIN_API = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs NETWORK_BINDING_AND_PUBLISHING = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs SNAPSHOT_REPOSITORY_ANALYSIS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs S3_COMPATIBLE_REPOSITORIES = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs LUCENE_MAX_DOCS_LIMIT = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs MAX_SHARDS_PER_NODE = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs FLOOD_STAGE_WATERMARK = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs X_OPAQUE_ID = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs FORMING_SINGLE_NODE_CLUSTERS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs CIRCUIT_BREAKER_ERRORS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs ALLOCATION_EXPLAIN_NO_COPIES = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs ALLOCATION_EXPLAIN_MAX_RETRY = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs SECURE_SETTINGS = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs CLUSTER_SHARD_LIMIT = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs DELETE_INDEX_BLOCK = new ReferenceDocs();
    public static final /* enum */ ReferenceDocs ARCHIVED_SETTINGS = new ReferenceDocs();
    private static final Map<String, LinkComponents> linksBySymbol;
    static final String UNRELEASED_VERSION_COMPONENT = "master";
    static final String CURRENT_VERSION_COMPONENT = "current";
    static final String VERSION_COMPONENT;
    static final int SYMBOL_COLUMN_WIDTH = 64;
    private static final /* synthetic */ ReferenceDocs[] $VALUES;

    public static ReferenceDocs[] values() {
        return (ReferenceDocs[])$VALUES.clone();
    }

    public static ReferenceDocs valueOf(String name) {
        return Enum.valueOf(ReferenceDocs.class, name);
    }

    static Map<String, LinkComponents> readLinksBySymbol(InputStream inputStream) throws IOException {
        Map.Entry[] linksBySymbolEntries = new Map.Entry[ReferenceDocs.values().length];
        ReferenceDocs.createLinkComponentEntries(inputStream, linksBySymbolEntries);
        return Map.ofEntries(linksBySymbolEntries);
    }

    private static void createLinkComponentEntries(InputStream inputStream, Map.Entry<?, ?>[] linksBySymbolEntries) throws IOException {
        String padding = " ".repeat(64);
        int symbolCount = linksBySymbolEntries.length;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            for (int i = 0; i < symbolCount; ++i) {
                String currentLine = reader.readLine();
                String symbol = ReferenceDocs.values()[i].name();
                if (currentLine == null) {
                    throw new IllegalStateException("links resource truncated at line " + (i + 1));
                }
                if (!currentLine.startsWith(symbol + " ")) {
                    throw new IllegalStateException("unexpected symbol at line " + (i + 1) + ": expected line starting with [" + symbol + " ]");
                }
                String link = currentLine.substring(64).trim();
                if (!Strings.hasText(link)) {
                    throw new IllegalStateException("no link found for [" + symbol + "] at line " + (i + 1));
                }
                String expectedLine = (symbol + padding).substring(0, 64) + link;
                if (!currentLine.equals(expectedLine)) {
                    throw new IllegalStateException("unexpected content at line " + (i + 1) + ": expected [" + expectedLine + "]");
                }
                if (link.startsWith("_") || link.contains("#_")) {
                    throw new IllegalStateException("found auto-generated fragment ID in link [" + link + "] for [" + symbol + "] at line " + (i + 1));
                }
                linksBySymbolEntries[i] = Map.entry(symbol, LinkComponents.ofLink(link));
            }
            if (reader.readLine() != null) {
                throw new IllegalStateException("unexpected trailing content at line " + (symbolCount + 1));
            }
        }
    }

    static String getVersionComponent(String version, boolean isSnapshot) {
        Pattern semanticVersionPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d)+");
        Matcher matcher = semanticVersionPattern.matcher(version);
        if (matcher.matches()) {
            String major = matcher.group(1);
            String minor = matcher.group(2);
            String revision = matcher.group(3);
            if (isSnapshot && "0".equals(revision)) {
                return UNRELEASED_VERSION_COMPONENT;
            }
            return major + "." + minor;
        }
        if (isSnapshot) {
            return UNRELEASED_VERSION_COMPONENT;
        }
        return CURRENT_VERSION_COMPONENT;
    }

    public String toString() {
        LinkComponents linkComponents = linksBySymbol.get(this.name());
        return "https://www.elastic.co/docs/" + linkComponents.path() + "?version=" + VERSION_COMPONENT + linkComponents.fragment();
    }

    @SuppressForbidden(reason="reads resource from jar")
    private static InputStream readFromJarResourceUrl(URL source) throws IOException {
        if (source == null) {
            throw new FileNotFoundException("links resource not found at [" + String.valueOf(source) + "]");
        }
        return source.openStream();
    }

    private static /* synthetic */ ReferenceDocs[] $values() {
        return new ReferenceDocs[]{INITIAL_MASTER_NODES, DISCOVERY_TROUBLESHOOTING, UNSTABLE_CLUSTER_TROUBLESHOOTING, LAGGING_NODE_TROUBLESHOOTING, SHARD_LOCK_TROUBLESHOOTING, NETWORK_DISCONNECT_TROUBLESHOOTING, CONCURRENT_REPOSITORY_WRITERS, ARCHIVE_INDICES, HTTP_TRACER, LOGGING, BOOTSTRAP_CHECK_HEAP_SIZE, BOOTSTRAP_CHECK_FILE_DESCRIPTOR, BOOTSTRAP_CHECK_MEMORY_LOCK, BOOTSTRAP_CHECK_MAX_NUMBER_THREADS, BOOTSTRAP_CHECK_MAX_FILE_SIZE, BOOTSTRAP_CHECK_MAX_SIZE_VIRTUAL_MEMORY, BOOTSTRAP_CHECK_MAXIMUM_MAP_COUNT, BOOTSTRAP_CHECK_CLIENT_JVM, BOOTSTRAP_CHECK_USE_SERIAL_COLLECTOR, BOOTSTRAP_CHECK_SYSTEM_CALL_FILTER, BOOTSTRAP_CHECK_ONERROR_AND_ONOUTOFMEMORYERROR, BOOTSTRAP_CHECK_EARLY_ACCESS, BOOTSTRAP_CHECK_ALL_PERMISSION, BOOTSTRAP_CHECK_DISCOVERY_CONFIGURATION, BOOTSTRAP_CHECKS, BOOTSTRAP_CHECK_ENCRYPT_SENSITIVE_DATA, BOOTSTRAP_CHECK_PKI_REALM, BOOTSTRAP_CHECK_ROLE_MAPPINGS, BOOTSTRAP_CHECK_TLS, BOOTSTRAP_CHECK_TOKEN_SSL, CONTACT_SUPPORT, UNASSIGNED_SHARDS, EXECUTABLE_JNA_TMPDIR, NETWORK_THREADING_MODEL, ALLOCATION_EXPLAIN_API, NETWORK_BINDING_AND_PUBLISHING, SNAPSHOT_REPOSITORY_ANALYSIS, S3_COMPATIBLE_REPOSITORIES, LUCENE_MAX_DOCS_LIMIT, MAX_SHARDS_PER_NODE, FLOOD_STAGE_WATERMARK, X_OPAQUE_ID, FORMING_SINGLE_NODE_CLUSTERS, CIRCUIT_BREAKER_ERRORS, ALLOCATION_EXPLAIN_NO_COPIES, ALLOCATION_EXPLAIN_MAX_RETRY, SECURE_SETTINGS, CLUSTER_SHARD_LIMIT, DELETE_INDEX_BLOCK, ARCHIVED_SETTINGS};
    }

    static {
        $VALUES = ReferenceDocs.$values();
        try (InputStream resourceStream = ReferenceDocs.readFromJarResourceUrl(ReferenceDocs.class.getResource("reference-docs-links.txt"));){
            linksBySymbol = Map.copyOf(ReferenceDocs.readLinksBySymbol(resourceStream));
        }
        catch (Exception e) {
            assert (false) : e;
            throw new IllegalStateException("could not read links resource", e);
        }
        VERSION_COMPONENT = ReferenceDocs.getVersionComponent(Build.current().version(), Build.current().isSnapshot());
    }

    record LinkComponents(String path, String fragment) {
        static LinkComponents ofLink(String link) {
            if (link.indexOf(63) != -1) {
                throw new IllegalStateException("ReferenceDocs does not support links containing pre-existing query parameters: " + link);
            }
            int fragmentIndex = link.indexOf(35);
            if (fragmentIndex == -1) {
                return new LinkComponents(link, "");
            }
            return new LinkComponents(link.substring(0, fragmentIndex), link.substring(fragmentIndex));
        }
    }
}

