/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.function.BiPredicate;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;

public class ShardsLimitAllocationDecider
extends AllocationDecider {
    public static final String NAME = "shards_limit";
    private volatile int clusterShardLimit;
    public static final Setting<Integer> INDEX_TOTAL_SHARDS_PER_NODE_SETTING = Setting.intSetting("index.routing.allocation.total_shards_per_node", -1, -1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING = Setting.intSetting("cluster.routing.allocation.total_shards_per_node", -1, -1, Setting.Property.Dynamic, Setting.Property.NodeScope);

    public ShardsLimitAllocationDecider(ClusterSettings clusterSettings) {
        clusterSettings.initializeAndWatch(CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING, this::setClusterShardLimit);
    }

    private void setClusterShardLimit(int clusterShardLimit) {
        this.clusterShardLimit = clusterShardLimit;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.doDecide(allocation.metadata().indexMetadata(shardRouting.index()), shardRouting, node, allocation, (count, limit) -> count >= limit);
    }

    @Override
    public Decision canRemain(IndexMetadata indexMetadata, ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.doDecide(indexMetadata, shardRouting, node, allocation, (count, limit) -> count > limit);
    }

    private Decision doDecide(IndexMetadata indexMd, ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, BiPredicate<Integer, Integer> decider) {
        int indexShardCount;
        int indexShardLimit = indexMd.getShardsPerNodeLimit();
        int clusterShardLimit = this.clusterShardLimit;
        if (indexShardLimit <= 0 && clusterShardLimit <= 0) {
            return allocation.decision(Decision.YES, NAME, "total shard limits are disabled: [index: %d, cluster: %d] <= 0", indexShardLimit, clusterShardLimit);
        }
        int nodeShardCount = node.numberOfOwningShards();
        if (clusterShardLimit > 0 && decider.test(nodeShardCount, clusterShardLimit)) {
            return allocation.decision(Decision.NO, NAME, "too many shards [%d] allocated to this node, cluster setting [%s=%d]", nodeShardCount, CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING.getKey(), clusterShardLimit);
        }
        if (indexShardLimit > 0 && decider.test(indexShardCount = node.numberOfOwningShardsForIndex(shardRouting.index()), indexShardLimit)) {
            return allocation.decision(Decision.NO, NAME, "too many shards [%d] allocated to this node for index [%s], index setting [%s=%d]", indexShardCount, shardRouting.getIndexName(), INDEX_TOTAL_SHARDS_PER_NODE_SETTING.getKey(), indexShardLimit);
        }
        return allocation.decision(Decision.YES, NAME, "the shard count [%d] for this node is under the index limit [%d] and cluster level node limit [%d]", nodeShardCount, indexShardLimit, clusterShardLimit);
    }
}

