/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Releasable;

public final class RefCountingListener
implements Releasable {
    private final ActionListener<Void> delegate;
    private final RefCountingRunnable refs = new RefCountingRunnable(this::finish);
    private final AtomicReference<Exception> exceptionRef = new AtomicReference();
    private final Semaphore exceptionPermits;
    private final AtomicInteger droppedExceptionsRef = new AtomicInteger();

    public RefCountingListener(ActionListener<Void> delegate) {
        this(10, delegate);
    }

    public RefCountingListener(int maxExceptions, ActionListener<Void> delegate) {
        if (maxExceptions <= 0) {
            assert (false) : maxExceptions;
            throw new IllegalArgumentException("maxExceptions must be positive");
        }
        this.delegate = ActionListener.assertOnce(Objects.requireNonNull(delegate));
        this.exceptionPermits = new Semaphore(maxExceptions);
    }

    public void close() {
        this.refs.close();
    }

    private void finish() {
        try {
            Exception exception = this.exceptionRef.get();
            if (exception == null) {
                this.delegate.onResponse(null);
            } else {
                int droppedExceptions = this.droppedExceptionsRef.getAndSet(0);
                if (droppedExceptions > 0) {
                    exception.addSuppressed(new ElasticsearchException(droppedExceptions + " further exceptions were dropped", new Object[0]));
                }
                this.delegate.onFailure(exception);
            }
        }
        catch (Exception e) {
            assert (false) : e;
            throw e;
        }
    }

    public ActionListener<Void> acquire() {
        return new ActionListener<Void>(){
            private final Releasable ref;
            {
                this.ref = RefCountingListener.this.refs.acquire();
            }

            @Override
            public void onResponse(Void unused) {
                this.ref.close();
            }

            @Override
            public void onFailure(Exception e) {
                try (Releasable releasable = this.ref;){
                    RefCountingListener.this.addException(e);
                }
            }

            public String toString() {
                return RefCountingListener.this.toString();
            }
        };
    }

    public <Response> ActionListener<Response> acquire(CheckedConsumer<Response, Exception> consumer) {
        final Releasable ref = this.refs.acquire();
        final AtomicReference<CheckedConsumer<Response, Exception>> consumerRef = new AtomicReference<CheckedConsumer<Response, Exception>>(Objects.requireNonNull(consumer));
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try (Releasable releasable = ref;){
                    CheckedConsumer acquiredConsumer = consumerRef.getAndSet(null);
                    if (acquiredConsumer == null) {
                        assert (false) : "already closed";
                    } else {
                        try {
                            acquiredConsumer.accept(response);
                        }
                        catch (Exception e) {
                            RefCountingListener.this.addException(e);
                        }
                    }
                }
            }

            @Override
            public void onFailure(Exception e) {
                try (Releasable releasable = ref;){
                    CheckedConsumer acquiredConsumer = consumerRef.getAndSet(null);
                    assert (acquiredConsumer != null) : "already closed";
                    RefCountingListener.this.addException(e);
                }
            }

            public String toString() {
                return String.valueOf(RefCountingListener.this) + "[" + String.valueOf(consumerRef.get()) + "]";
            }
        };
    }

    private void addException(Exception e) {
        if (this.exceptionPermits.tryAcquire()) {
            Exception firstException = this.exceptionRef.compareAndExchange(null, e);
            if (firstException != null && firstException != e) {
                firstException.addSuppressed(e);
            }
        } else {
            this.droppedExceptionsRef.incrementAndGet();
        }
    }

    public String toString() {
        return "refCounting[" + String.valueOf(this.delegate) + "]";
    }

    public boolean isFailing() {
        return this.exceptionRef.get() != null;
    }
}

