/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.settings.ClusterGetSettingsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.local.TransportLocalClusterStateAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportClusterGetSettingsAction
extends TransportLocalClusterStateAction<ClusterGetSettingsAction.Request, ClusterGetSettingsAction.Response> {
    private final SettingsFilter settingsFilter;

    @Inject
    public TransportClusterGetSettingsAction(TransportService transportService, ClusterService clusterService, SettingsFilter settingsFilter, ActionFilters actionFilters) {
        super("cluster:monitor/settings", actionFilters, transportService.getTaskManager(), clusterService, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.settingsFilter = settingsFilter;
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, ClusterGetSettingsAction.Request::new, (request, channel, task) -> this.executeDirect(task, request, new ChannelActionListener(channel)));
    }

    @Override
    protected void localClusterStateOperation(Task task, ClusterGetSettingsAction.Request request, ClusterState state, ActionListener<ClusterGetSettingsAction.Response> listener) throws Exception {
        ((CancellableTask)task).ensureNotCancelled();
        Metadata metadata = state.metadata();
        listener.onResponse(new ClusterGetSettingsAction.Response(this.settingsFilter.filter(metadata.persistentSettings()), this.settingsFilter.filter(metadata.transientSettings()), this.settingsFilter.filter(metadata.settings())));
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterGetSettingsAction.Request request, ClusterState state) {
        return null;
    }
}

