/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.util;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.UncheckedIOException;

public final class FileUtils {
    public static void mkdirs(File dir) {
        if ((dir = dir.getAbsoluteFile()).isDirectory()) {
            return;
        }
        if (dir.exists() && !dir.isDirectory()) {
            throw new UncheckedIOException(String.format("Cannot create directory '%s' as it already exists, but is not a directory", dir));
        }
        LinkedList<File> toCreate = new LinkedList<File>();
        File parent = dir.getParentFile();
        while (!parent.exists()) {
            toCreate.add(parent);
            parent = parent.getParentFile();
        }
        Collections.reverse(toCreate);
        for (File parentDirToCreate : toCreate) {
            if (parentDirToCreate.isDirectory()) continue;
            File parentDirToCreateParent = parentDirToCreate.getParentFile();
            if (!parentDirToCreateParent.isDirectory()) {
                throw new UncheckedIOException(String.format("Cannot create parent directory '%s' when creating directory '%s' as '%s' is not a directory", parentDirToCreate, dir, parentDirToCreateParent));
            }
            if (parentDirToCreate.mkdir() || parentDirToCreate.isDirectory()) continue;
            throw new UncheckedIOException(String.format("Failed to create parent directory '%s' when creating directory '%s'", parentDirToCreate, dir));
        }
        if (!dir.mkdir() && !dir.isDirectory()) {
            throw new UncheckedIOException(String.format("Failed to create directory '%s'", dir));
        }
    }

    public static String read(File file, String encoding) {
        try {
            return org.apache.commons.io.FileUtils.readFileToString((File)file, (String)encoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static List<String> readLines(File file, String encoding) {
        try {
            return org.apache.commons.io.FileUtils.readLines((File)file, (String)encoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void write(File outputFile, CharSequence content, String encoding) {
        try {
            org.apache.commons.io.FileUtils.write((File)outputFile, (CharSequence)content, (String)encoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }
}

