/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.transform;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import java.util.List;
import java.util.function.Function;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

public interface UnpackTransform
extends TransformAction<Parameters> {
    public static final Logger LOGGER = Logging.getLogger(UnpackTransform.class);

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputArtifact
    public Provider<FileSystemLocation> getArchiveFile();

    default public void transform(TransformOutputs outputs) {
        File archiveFile = ((FileSystemLocation)this.getArchiveFile().get()).getAsFile();
        File extractedDir = outputs.dir((Object)archiveFile.getName());
        if (((Boolean)((Parameters)this.getParameters()).getIncludeArtifactName().getOrElse((Object)false)).booleanValue()) {
            extractedDir = new File(extractedDir, archiveFile.getName());
        }
        try {
            LOGGER.info("Unpacking {} using {}.", (Object)archiveFile.getName(), (Object)this.getClass().getSimpleName());
            this.unpack(archiveFile, extractedDir, outputs, ((Parameters)this.getParameters()).getAsFiletreeOutput());
        }
        catch (IOException e1) {
            String hash = "[unknown]";
            try {
                hash = UnpackTransform.getSha1(archiveFile);
            }
            catch (Exception e2) {
                LOGGER.warn("Unable to calculate hash for file " + archiveFile.getPath(), (Throwable)e2);
            }
            throw new UncheckedIOException("Failed to unpack " + archiveFile.getName() + " with checksum " + hash, e1);
        }
    }

    public void unpack(File var1, File var2, TransformOutputs var3, boolean var4) throws IOException;

    default public Function<String, Path> pathResolver() {
        List<String> keepPatterns = ((Parameters)this.getParameters()).getKeepStructureFor();
        String trimmedPrefixPattern = ((Parameters)this.getParameters()).getTrimmedPrefixPattern();
        return trimmedPrefixPattern != null ? i -> UnpackTransform.trimArchiveExtractPath(keepPatterns, trimmedPrefixPattern, i) : i -> Path.of(i, new String[0]);
    }

    public static Path trimArchiveExtractPath(List<String> keepPatterns, String ignoredPattern, String relativePath) {
        int index;
        Path entryName = Paths.get(relativePath, new String[0]);
        if (keepPatterns != null && keepPatterns.stream().anyMatch(keepPattern -> entryName.getName(0).toString().matches((String)keepPattern))) {
            if (entryName.getNameCount() == 1) {
                return null;
            }
            return entryName.subpath(1, entryName.getNameCount());
        }
        for (index = 0; index < entryName.getNameCount() && !entryName.getName(index).toString().matches(ignoredPattern); ++index) {
        }
        if (index + 1 >= entryName.getNameCount()) {
            return null;
        }
        return entryName.subpath(index + 1, entryName.getNameCount());
    }

    public static String getSha1(File file) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        try (DigestInputStream is = new DigestInputStream(new FileInputStream(file), digest);){
            byte[] buffer = new byte[4096];
            while (((InputStream)is).read(buffer) > 0) {
            }
        }
        return HexFormat.of().formatHex(digest.digest());
    }

    public static interface Parameters
    extends TransformParameters {
        @Input
        @Optional
        public String getTrimmedPrefixPattern();

        public void setTrimmedPrefixPattern(String var1);

        @Input
        @Optional
        public List<String> getKeepStructureFor();

        @Input
        public boolean getAsFiletreeOutput();

        public void setAsFiletreeOutput(boolean var1);

        @Internal
        public File getTargetDirectory();

        public void setTargetDirectory(File var1);

        public void setKeepStructureFor(List<String> var1);

        @Input
        @Optional
        public Property<Boolean> getIncludeArtifactName();
    }
}

