/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.xpack.core.security.authz.IndicesAndAliasesResolverField;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;
import org.elasticsearch.xpack.esql.session.Configuration;

final class DataNodeRequest
extends AbstractTransportRequest
implements IndicesRequest.Replaceable {
    private static final Logger logger = LogManager.getLogger(DataNodeRequest.class);
    private final String sessionId;
    private final Configuration configuration;
    private final String clusterAlias;
    private final Map<Index, AliasFilter> aliasFilters;
    private final PhysicalPlan plan;
    private List<ShardId> shardIds;
    private String[] indices;
    private final IndicesOptions indicesOptions;
    private final boolean runNodeLevelReduction;

    DataNodeRequest(String sessionId, Configuration configuration, String clusterAlias, List<ShardId> shardIds, Map<Index, AliasFilter> aliasFilters, PhysicalPlan plan, String[] indices, IndicesOptions indicesOptions, boolean runNodeLevelReduction) {
        this.sessionId = sessionId;
        this.configuration = configuration;
        this.clusterAlias = clusterAlias;
        this.shardIds = shardIds;
        this.aliasFilters = aliasFilters;
        this.plan = plan;
        this.indices = indices;
        this.indicesOptions = indicesOptions;
        this.runNodeLevelReduction = runNodeLevelReduction;
    }

    DataNodeRequest(StreamInput in) throws IOException {
        super(in);
        this.sessionId = in.readString();
        this.configuration = new Configuration(new BlockStreamInput(in, new BlockFactory((CircuitBreaker)new NoopCircuitBreaker("request"), BigArrays.NON_RECYCLING_INSTANCE)));
        this.clusterAlias = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0) ? in.readString() : "";
        this.shardIds = in.readCollectionAsList(ShardId::new);
        this.aliasFilters = in.readMap(Index::new, AliasFilter::readFrom);
        this.plan = (PhysicalPlan)new PlanStreamInput(in, in.namedWriteableRegistry(), this.configuration).readNamedWriteable(PhysicalPlan.class);
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            this.indices = in.readStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        } else {
            this.indices = (String[])this.shardIds.stream().map(ShardId::getIndexName).distinct().toArray(String[]::new);
            this.indicesOptions = IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }
        this.runNodeLevelReduction = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.sessionId);
        this.configuration.writeTo(out);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            out.writeString(this.clusterAlias);
        }
        out.writeCollection(this.shardIds);
        out.writeMap(this.aliasFilters);
        new PlanStreamOutput(out, this.configuration).writeNamedWriteable((NamedWriteable)this.plan);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_16_0)) {
            out.writeStringArray(this.indices);
            this.indicesOptions.writeIndicesOptions(out);
        }
        out.writeBoolean(this.runNodeLevelReduction);
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesRequest indices(String ... indices) {
        this.indices = indices;
        if (Arrays.equals(IndicesAndAliasesResolverField.NO_INDICES_OR_ALIASES_ARRAY, indices) || Arrays.asList(indices).contains("-*")) {
            logger.trace(() -> Strings.format((String)"Indices empty after index resolution, also clearing shardIds %s", (Object[])new Object[]{this.shardIds}));
            this.shardIds = Collections.emptyList();
        }
        return this;
    }

    public boolean includeDataStreams() {
        return true;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        if (!parentTaskId.isSet()) {
            assert (false) : "DataNodeRequest must have a parent task";
            throw new IllegalStateException("DataNodeRequest must have a parent task");
        }
        return new CancellableTask(id, type, action, "", parentTaskId, headers){

            public String getDescription() {
                return DataNodeRequest.this.getDescription();
            }
        };
    }

    String sessionId() {
        return this.sessionId;
    }

    Configuration configuration() {
        return this.configuration;
    }

    QueryPragmas pragmas() {
        return this.configuration.pragmas();
    }

    String clusterAlias() {
        return this.clusterAlias;
    }

    List<ShardId> shardIds() {
        return this.shardIds;
    }

    Map<Index, AliasFilter> aliasFilters() {
        return this.aliasFilters;
    }

    PhysicalPlan plan() {
        return this.plan;
    }

    boolean runNodeLevelReduction() {
        return this.runNodeLevelReduction;
    }

    public String getDescription() {
        return "shards=" + String.valueOf(this.shardIds) + " plan=" + String.valueOf((Object)this.plan);
    }

    public String toString() {
        return "DataNodeRequest{" + this.getDescription() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DataNodeRequest request = (DataNodeRequest)((Object)o);
        return this.sessionId.equals(request.sessionId) && this.configuration.equals(request.configuration) && this.clusterAlias.equals(request.clusterAlias) && this.shardIds.equals(request.shardIds) && this.aliasFilters.equals(request.aliasFilters) && this.plan.equals((Object)request.plan) && this.getParentTask().equals((Object)request.getParentTask()) && Arrays.equals(this.indices, request.indices) && this.indicesOptions.equals((Object)request.indicesOptions) && this.runNodeLevelReduction == request.runNodeLevelReduction;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sessionId, this.configuration, this.clusterAlias, this.shardIds, this.aliasFilters, this.plan, Arrays.hashCode(this.indices), this.indicesOptions, this.runNodeLevelReduction});
    }
}

