/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class PhysicalSettings {
    public static final Setting<DataPartitioning> DEFAULT_DATA_PARTITIONING = Setting.enumSetting(DataPartitioning.class, (String)"esql.default_data_partitioning", (Enum)DataPartitioning.AUTO, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<ByteSizeValue> VALUES_LOADING_JUMBO_SIZE = new Setting("esql.values_loading_jumbo_size", settings -> {
        long proportional = JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() / 1024L;
        return ByteSizeValue.ofBytes((long)Math.max(proportional, ByteSizeValue.ofMb((long)1L).getBytes())).getStringRep();
    }, s -> MemorySizeValue.parseBytesSizeValueOrHeapRatio((String)s, (String)"esql.values_loading_jumbo_size"), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private volatile DataPartitioning defaultDataPartitioning;
    private volatile ByteSizeValue valuesLoadingJumboSize;

    public PhysicalSettings(ClusterService clusterService) {
        clusterService.getClusterSettings().initializeAndWatch(DEFAULT_DATA_PARTITIONING, v -> {
            this.defaultDataPartitioning = v;
        });
        clusterService.getClusterSettings().initializeAndWatch(VALUES_LOADING_JUMBO_SIZE, v -> {
            this.valuesLoadingJumboSize = v;
        });
    }

    public PhysicalSettings(DataPartitioning defaultDataPartitioning, ByteSizeValue valuesLoadingJumboSize) {
        this.defaultDataPartitioning = defaultDataPartitioning;
        this.valuesLoadingJumboSize = valuesLoadingJumboSize;
    }

    public DataPartitioning defaultDataPartitioning() {
        return this.defaultDataPartitioning;
    }

    public ByteSizeValue valuesLoadingJumboSize() {
        return this.valuesLoadingJumboSize;
    }
}

