/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Values;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.SurrogateLogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class Dedup
extends UnaryPlan
implements SurrogateLogicalPlan {
    private final List<NamedExpression> aggregates;
    private final List<Attribute> groupings;
    private List<Attribute> lazyOutput;
    private List<NamedExpression> lazyFinalAggs;

    public Dedup(Source source, LogicalPlan child, List<NamedExpression> aggregates, List<Attribute> groupings) {
        super(source, child);
        this.aggregates = aggregates;
        this.groupings = groupings;
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, Dedup::new, (Object)((Object)this.child()), this.aggregates, this.groupings);
    }

    @Override
    public boolean expressionsResolved() {
        return Resolvables.resolved(this.aggregates) && Resolvables.resolved(this.groupings);
    }

    @Override
    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Dedup(this.source(), newChild, this.aggregates, this.groupings);
    }

    @Override
    public LogicalPlan surrogate() {
        return new Aggregate(this.source(), this.child(), new ArrayList<Attribute>(this.groupings), this.finalAggs());
    }

    public List<NamedExpression> aggregates() {
        return this.aggregates;
    }

    public List<Attribute> groupings() {
        return this.groupings;
    }

    public List<NamedExpression> finalAggs() {
        if (this.lazyFinalAggs == null) {
            this.lazyFinalAggs = new ArrayList<NamedExpression>(this.aggregates);
            HashSet<String> names = new HashSet<String>(this.aggregates.stream().map(att -> att.name()).toList());
            Literal aggFilter = new Literal(this.source(), (Object)true, DataType.BOOLEAN);
            for (Attribute attr : this.child().output()) {
                if (names.contains(attr.name())) continue;
                this.lazyFinalAggs.add((NamedExpression)new Alias(this.source(), attr.name(), (Expression)new Values(this.source(), (Expression)attr, (Expression)aggFilter)));
            }
        }
        return this.lazyFinalAggs;
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = NamedExpressions.mergeOutputAttributes(this.finalAggs(), this.child().output());
        }
        return this.lazyOutput;
    }
}

