/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedianAbsoluteDeviation;

public final class MvMedianAbsoluteDeviationIntEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvMedianAbsoluteDeviationIntEvaluator.class);

    public MvMedianAbsoluteDeviationIntEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvMedianAbsoluteDeviation";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNullable(fieldVal);
        }
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Longs work = new MvMedianAbsoluteDeviation.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int result;
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                if (valueCount == 1) {
                    int value = v.getInt(first);
                    result = MvMedianAbsoluteDeviation.single(value);
                    builder.appendInt(result);
                    continue;
                }
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    int value = v.getInt(i);
                    MvMedianAbsoluteDeviation.process(work, value);
                }
                result = MvMedianAbsoluteDeviation.finishInts(work);
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNotNullable(fieldVal);
        }
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntVector.FixedBuilder builder = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Longs work = new MvMedianAbsoluteDeviation.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int result;
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                if (valueCount == 1) {
                    int value = v.getInt(first);
                    result = MvMedianAbsoluteDeviation.single(value);
                    builder.appendInt(result);
                    continue;
                }
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    int value = v.getInt(i);
                    MvMedianAbsoluteDeviation.process(work, value);
                }
                result = MvMedianAbsoluteDeviation.finishInts(work);
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build().asBlock();
            return intBlock;
        }
    }

    @Override
    public Block evalSingleValuedNullable(Block fieldVal) {
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Longs work = new MvMedianAbsoluteDeviation.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                assert (valueCount == 1);
                int first = v.getFirstValueIndex(p);
                int value = v.getInt(first);
                int result = MvMedianAbsoluteDeviation.single(value);
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    @Override
    public Block evalSingleValuedNotNullable(Block fieldVal) {
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntVector.FixedBuilder builder = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Longs work = new MvMedianAbsoluteDeviation.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                assert (valueCount == 1);
                int first = v.getFirstValueIndex(p);
                int value = v.getInt(first);
                int result = MvMedianAbsoluteDeviation.single(value);
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build().asBlock();
            return intBlock;
        }
    }

    private Block evalAscendingNullable(Block fieldVal) {
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Longs work = new MvMedianAbsoluteDeviation.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int result = MvMedianAbsoluteDeviation.ascending(work, v, first, valueCount);
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private Block evalAscendingNotNullable(Block fieldVal) {
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntVector.FixedBuilder builder = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            MvMedianAbsoluteDeviation.Longs work = new MvMedianAbsoluteDeviation.Longs();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int result = MvMedianAbsoluteDeviation.ascending(work, v, first, valueCount);
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build().asBlock();
            return intBlock;
        }
    }

    public long baseRamBytesUsed() {
        return BASE_RAM_BYTES_USED + this.field.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvMedianAbsoluteDeviationIntEvaluator get(DriverContext context) {
            return new MvMedianAbsoluteDeviationIntEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvMedianAbsoluteDeviation[field=" + String.valueOf(this.field) + "]";
        }
    }
}

