/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CopySignDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CopySignFloatEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CopySignIntegerEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CopySignLongEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class CopySign
extends EsqlScalarFunction {
    public static final String NAME = "copy_sign";
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "copy_sign", CopySign::new);
    private static final Map<DataType, CopySignFactoryProvider> FACTORY_PROVIDERS = Map.ofEntries(Map.entry(DataType.FLOAT, CopySignFloatEvaluator.Factory::new), Map.entry(DataType.DOUBLE, CopySignDoubleEvaluator.Factory::new), Map.entry(DataType.LONG, CopySignLongEvaluator.Factory::new), Map.entry(DataType.INTEGER, CopySignIntegerEvaluator.Factory::new));
    private DataType dataType;

    @FunctionInfo(description="Returns a value with the magnitude of the first argument and the sign of the second argument.\nThis function is similar to Java's Math.copySign(double magnitude, double sign) which is\nsimilar to `copysign` from [IEEE 754](https://en.wikipedia.org/wiki/IEEE_754).", returnType={"double", "integer", "long"})
    public CopySign(Source source, @Param(name="magnitude", type={"double", "integer", "long"}, description="The expression providing the magnitude of the result. Must be a numeric type.") Expression magnitude, @Param(name="sign", type={"double", "integer", "long"}, description="The expression providing the sign of the result. Must be a numeric type.") Expression sign) {
        super(source, Arrays.asList(magnitude, sign));
    }

    private CopySign(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeNamedWriteable((NamedWriteable)this.children().get(1));
    }

    public String getWriteableName() {
        return CopySign.ENTRY.name;
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, CopySign::new, (Object)((Expression)this.children().get(0)), (Object)((Expression)this.children().get(1)));
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 2) {
            throw new EsqlIllegalArgumentException("Function [{}] expects exactly two arguments, got [{}]", NAME, newChildren.size());
        }
        return new CopySign(this.source(), newChildren.get(0), newChildren.get(1));
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.resolveType();
        }
        return this.dataType;
    }

    public Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression magnitude = (Expression)this.children().get(0);
        Expression sign = (Expression)this.children().get(1);
        Expression.TypeResolution resolution = TypeResolutions.isType((Expression)magnitude, t -> t.isNumeric() && t != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"numeric"});
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isType((Expression)sign, t -> t.isNumeric() && t != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"numeric"});
        if (resolution.unresolved()) {
            return resolution;
        }
        this.dataType = magnitude.dataType();
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        DataType dataType = this.dataType();
        if (!FACTORY_PROVIDERS.containsKey(dataType)) {
            throw new EsqlIllegalArgumentException("Unsupported data type [{}] for function [{}]", this.dataType(), NAME);
        }
        Expression sign = (Expression)this.children().get(1);
        Expression magnitude = (Expression)this.children().get(0);
        return FACTORY_PROVIDERS.get(dataType).create(this.source(), toEvaluator.apply(magnitude), Cast.cast(this.source(), sign.dataType(), DataType.DOUBLE, toEvaluator.apply(sign)));
    }

    static float processFloat(float magnitude, double sign) {
        if (sign < 0.0) {
            return magnitude < 0.0f ? magnitude : -magnitude;
        }
        return magnitude < 0.0f ? -magnitude : magnitude;
    }

    static double processDouble(double magnitude, double sign) {
        return Math.copySign(magnitude, sign);
    }

    static long processLong(long magnitude, double sign) {
        if (sign < 0.0) {
            return magnitude < 0L ? magnitude : -magnitude;
        }
        return magnitude < 0L ? -magnitude : magnitude;
    }

    static int processInteger(int magnitude, double sign) {
        if (sign < 0.0) {
            return magnitude < 0 ? magnitude : -magnitude;
        }
        return magnitude < 0 ? -magnitude : magnitude;
    }

    private static interface CopySignFactoryProvider {
        public EvalOperator.ExpressionEvaluator.Factory create(Source var1, EvalOperator.ExpressionEvaluator.Factory var2, EvalOperator.ExpressionEvaluator.Factory var3);
    }
}

