/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisPlanVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.MapParam;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.expression.function.fulltext.Match;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.querydsl.query.MultiMatchQuery;

public class MultiMatch
extends FullTextFunction
implements OptionalArgument,
PostAnalysisPlanVerificationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MultiMatch", MultiMatch::readFrom);
    public static final Set<DataType> QUERY_DATA_TYPES = Set.of(DataType.KEYWORD, DataType.BOOLEAN, DataType.DATETIME, DataType.DATE_NANOS, DataType.DOUBLE, DataType.INTEGER, DataType.IP, DataType.LONG, DataType.UNSIGNED_LONG, DataType.VERSION);
    public static final Set<DataType> FIELD_DATA_TYPES = Set.of(DataType.KEYWORD, DataType.TEXT, DataType.BOOLEAN, DataType.DATETIME, DataType.DATE_NANOS, DataType.DOUBLE, DataType.INTEGER, DataType.IP, DataType.LONG, DataType.UNSIGNED_LONG, DataType.VERSION);
    public static final Map<String, DataType> OPTIONS = Map.ofEntries(Map.entry(MultiMatchQueryBuilder.BOOST_FIELD.getPreferredName(), DataType.FLOAT), Map.entry(MultiMatchQueryBuilder.SLOP_FIELD.getPreferredName(), DataType.INTEGER), Map.entry(MultiMatchQueryBuilder.ANALYZER_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(MultiMatchQueryBuilder.GENERATE_SYNONYMS_PHRASE_QUERY.getPreferredName(), DataType.BOOLEAN), Map.entry(MultiMatchQueryBuilder.FUZZINESS_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(MultiMatchQueryBuilder.FUZZY_REWRITE_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(MultiMatchQueryBuilder.FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), DataType.BOOLEAN), Map.entry(MultiMatchQueryBuilder.LENIENT_FIELD.getPreferredName(), DataType.BOOLEAN), Map.entry(MultiMatchQueryBuilder.MAX_EXPANSIONS_FIELD.getPreferredName(), DataType.INTEGER), Map.entry(MultiMatchQueryBuilder.MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(MultiMatchQueryBuilder.OPERATOR_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(MultiMatchQueryBuilder.PREFIX_LENGTH_FIELD.getPreferredName(), DataType.INTEGER), Map.entry(MultiMatchQueryBuilder.TIE_BREAKER_FIELD.getPreferredName(), DataType.FLOAT), Map.entry(MultiMatchQueryBuilder.TYPE_FIELD.getPreferredName(), DataType.KEYWORD));
    private final transient List<Expression> fields;
    private final transient List<Expression> fieldsOriginal;
    private final transient Expression options;
    private final transient Expression optionsOriginal;

    @FunctionInfo(returnType={"boolean"}, preview=true, description="Use `MULTI_MATCH` to perform a <<query-dsl-multi-match-query,multi-match query>> on the specified field.\nThe multi_match query builds on the match query to allow multi-field queries.", examples={@Example(file="multi-match-function", tag="multi-match-with-field"), @Example(file="multi-match-function", tag="multi-match-with-named-function-params")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.COMING, version="9.1.0", description="Support for optional named parameters is only available from 9.1.0")})
    public MultiMatch(Source source, @Param(name="query", type={"keyword", "boolean", "date", "date_nanos", "double", "integer", "ip", "long", "text", "unsigned_long", "version"}, description="Value to find in the provided fields.") Expression query, @Param(name="fields", type={"keyword", "boolean", "date", "date_nanos", "double", "integer", "ip", "long", "unsigned_long", "version"}, description="Fields to use for matching") List<Expression> fields, @MapParam(name="options", params={@MapParam.MapParamEntry(name="boost", type={"float"}, valueHint={"2.5"}, description="Floating point number used to decrease or increase the relevance scores of the query."), @MapParam.MapParamEntry(name="analyzer", type={"keyword"}, valueHint={"standard"}, description="Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index\u2019s default analyzer is used."), @MapParam.MapParamEntry(name="auto_generate_synonyms_phrase_query", type={"boolean"}, valueHint={"true", "false"}, description="If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true."), @MapParam.MapParamEntry(name="fuzziness", type={"keyword"}, valueHint={"AUTO", "1", "2"}, description="Maximum edit distance allowed for matching."), @MapParam.MapParamEntry(name="fuzzy_rewrite", type={"keyword"}, valueHint={"constant_score_blended", "constant_score", "constant_score_boolean", "top_terms_blended_freqs_N", "top_terms_boost_N", "top_terms_N"}, description="Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default."), @MapParam.MapParamEntry(name="fuzzy_transpositions", type={"boolean"}, valueHint={"true", "false"}, description="If true, edits for fuzzy matching include transpositions of two adjacent characters (ab \u2192 ba). Defaults to true."), @MapParam.MapParamEntry(name="lenient", type={"boolean"}, valueHint={"true", "false"}, description="If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to true."), @MapParam.MapParamEntry(name="max_expansions", type={"integer"}, valueHint={"50"}, description="Maximum number of terms to which the query will expand. Defaults to 50."), @MapParam.MapParamEntry(name="minimum_should_match", type={"integer"}, valueHint={"2"}, description="Minimum number of clauses that must match for a document to be returned."), @MapParam.MapParamEntry(name="operator", type={"keyword"}, valueHint={"AND", "OR"}, description="Boolean logic used to interpret text in the query value. Defaults to OR."), @MapParam.MapParamEntry(name="prefix_length", type={"integer"}, valueHint={"1"}, description="Number of beginning characters left unchanged for fuzzy matching. Defaults to 0."), @MapParam.MapParamEntry(name="tie_breaker", type={"float"}, valueHint={"0"}, description="Controls how score is blended together between field groups. Defaults to 0 (best score from each group)."), @MapParam.MapParamEntry(name="type", type={"object"}, valueHint={"'best_fields'"}, description="Controls the way multi_match is executed internally. Can be one of `best_fields`, `most_fields`, `cross_fields`, `phrase`, `phrase_prefix` or `bool_prefix`. Defaults to 'best_fields'. See <<multi-match-types,multi_match types>>.")}, description="(Optional) Additional options for MultiMatch, passed as <<esql-function-named-params,function named parameters>>.\"\n See <<query-dsl-multi-match-query,multi-match query>> for more information.", optional=true) Expression options) {
        this(source, query, fields, options, null);
    }

    private static List<Expression> initChildren(Expression query, List<Expression> fields, Expression options) {
        Stream<Expression> fieldsAndQuery = Stream.concat(Stream.of(query), fields.stream());
        return (options == null ? fieldsAndQuery : Stream.concat(fieldsAndQuery, Stream.of(options))).toList();
    }

    private MultiMatch(Source source, Expression query, List<Expression> fields, Expression options, QueryBuilder queryBuilder) {
        super(source, query, MultiMatch.initChildren(query, fields, options), queryBuilder);
        this.fieldsOriginal = fields;
        this.optionsOriginal = options;
        if (options == null || options instanceof MapExpression) {
            this.fields = fields;
            this.options = options;
        } else {
            this.fields = Stream.concat(fields.stream(), Stream.of(options)).toList();
            this.options = null;
        }
    }

    private static MultiMatch readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        Expression query = (Expression)in.readNamedWriteable(Expression.class);
        List fields = in.readNamedWriteableCollectionAsList(Expression.class);
        QueryBuilder queryBuilder = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        return new MultiMatch(source, query, fields, null, queryBuilder);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.query());
        out.writeNamedWriteableCollection(this.fields);
        out.writeOptionalNamedWriteable((NamedWriteable)this.queryBuilder());
    }

    public String getWriteableName() {
        return MultiMatch.ENTRY.name;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.getLast() instanceof MapExpression || newChildren.size() == this.children().size()) {
            return new MultiMatch(this.source(), newChildren.getFirst(), newChildren.subList(1, newChildren.size() - 1), newChildren.getLast(), this.queryBuilder());
        }
        return new MultiMatch(this.source(), newChildren.getFirst(), newChildren.subList(1, newChildren.size()), null, this.queryBuilder());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MultiMatch::new, (Object)this.query(), this.fieldsOriginal, (Object)this.optionsOriginal);
    }

    @Override
    protected Query translate(TranslatorHandler handler) {
        HashMap<String, Float> fieldsWithBoost = new HashMap<String, Float>();
        for (Expression field : this.fields) {
            FieldAttribute fieldAttribute = Match.fieldAsFieldAttribute(field);
            Check.notNull((Object)fieldAttribute, (String)"MultiMatch must have field attributes as arguments #2 to #N-1.");
            String fieldName = Match.getNameFromFieldAttribute(fieldAttribute);
            fieldsWithBoost.put(fieldName, Float.valueOf(1.0f));
        }
        return new MultiMatchQuery(this.source(), Objects.toString(this.queryAsObject()), fieldsWithBoost, this.getOptions());
    }

    @Override
    public Expression replaceQueryBuilder(QueryBuilder queryBuilder) {
        return new MultiMatch(this.source(), this.query(), this.fieldsOriginal, this.optionsOriginal, queryBuilder);
    }

    public List<Expression> fields() {
        return this.fields;
    }

    public Expression options() {
        return this.options;
    }

    private Map<String, Object> getOptions() throws InvalidArgumentException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(MatchQueryBuilder.LENIENT_FIELD.getPreferredName(), true);
        if (this.options() == null) {
            return options;
        }
        Match.populateOptionsMap((MapExpression)this.options(), options, TypeResolutions.ParamOrdinal.THIRD, this.sourceText(), OPTIONS);
        return options;
    }

    public String functionName() {
        return MultiMatch.ENTRY.name;
    }

    private Expression.TypeResolution resolveFields() {
        return this.fields.stream().map(field -> TypeResolutions.isNotNull((Expression)field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND).and(TypeResolutions.isType((Expression)field, FIELD_DATA_TYPES::contains, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"keyword, text, boolean, date, date_nanos, double, integer, ip, long, unsigned_long, version"}))).reduce(Expression.TypeResolution::and).orElse(null);
    }

    private Expression.TypeResolution resolveOptions() {
        if (this.options() != null) {
            Expression.TypeResolution resolution = TypeResolutions.isNotNull((Expression)this.options(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD);
            if (resolution.unresolved()) {
                return resolution;
            }
            resolution = TypeResolutions.isMapExpression((Expression)this.options(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD);
            if (resolution.unresolved()) {
                return resolution;
            }
            try {
                this.getOptions();
            }
            catch (InvalidArgumentException e) {
                return new Expression.TypeResolution(e.getMessage());
            }
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    private Expression.TypeResolution resolveQuery() {
        return TypeResolutions.isType((Expression)this.query(), QUERY_DATA_TYPES::contains, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"keyword, boolean, date, date_nanos, double, integer, ip, long, unsigned_long, version"}).and(TypeResolutions.isNotNullAndFoldable((Expression)this.query(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST));
    }

    @Override
    protected Expression.TypeResolution resolveParams() {
        return this.resolveQuery().and(this.resolveFields()).and(this.resolveOptions());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiMatch mm = (MultiMatch)o;
        return Objects.equals(this.fields(), mm.fields()) && Objects.equals(this.query(), mm.query()) && Objects.equals(this.queryBuilder(), mm.queryBuilder());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fields(), this.query(), this.queryBuilder());
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return (plan, failures) -> {
            super.postAnalysisPlanVerification().accept((LogicalPlan)((Object)plan), (Failures)failures);
            plan.forEachExpression(MultiMatch.class, mm -> {
                for (Expression field : this.fields) {
                    if (Match.fieldAsFieldAttribute(field) != null) continue;
                    failures.add(Failure.fail(field, "[{}] {} cannot operate on [{}], which is not a field from an index mapping", new Object[]{this.functionName(), this.functionType(), field.sourceText()}));
                }
            });
        };
    }
}

