/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.security.SecurityFeatureSetUsage;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.SecurityUsageServices;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;
import org.elasticsearch.xpack.security.operator.OperatorPrivileges;
import org.elasticsearch.xpack.security.profile.ProfileService;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;

public class SecurityUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final Settings settings;
    private final XPackLicenseState licenseState;
    private final Realms realms;
    private final CompositeRolesStore rolesStore;
    private final NativeRoleMappingStore roleMappingStore;
    private final IPFilter ipFilter;
    private final ProfileService profileService;
    private final ApiKeyService apiKeyService;

    @Inject
    public SecurityUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Settings settings, XPackLicenseState licenseState, SecurityUsageServices securityServices) {
        super(XPackUsageFeatureAction.SECURITY.name(), transportService, clusterService, threadPool, actionFilters);
        this.settings = settings;
        this.licenseState = licenseState;
        this.realms = securityServices.realms;
        this.rolesStore = securityServices.rolesStore;
        this.roleMappingStore = securityServices.roleMappingStore;
        this.ipFilter = securityServices.ipFilter;
        this.profileService = securityServices.profileService;
        this.apiKeyService = securityServices.apiKeyService;
    }

    protected void localClusterStateOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        Map<String, Object> sslUsage = SecurityUsageTransportAction.sslUsage(this.settings);
        Map<String, Object> tokenServiceUsage = SecurityUsageTransportAction.tokenServiceUsage(this.settings);
        Map<String, Object> apiKeyServiceUsage = SecurityUsageTransportAction.apiKeyServiceUsage(this.settings);
        Map<String, Object> auditUsage = SecurityUsageTransportAction.auditUsage(this.settings);
        Map<String, Object> ipFilterUsage = SecurityUsageTransportAction.ipFilterUsage(this.ipFilter);
        Map<String, Boolean> anonymousUsage = Collections.singletonMap("enabled", AnonymousUser.isAnonymousEnabled((Settings)this.settings));
        Map<String, Object> fips140Usage = SecurityUsageTransportAction.fips140Usage(this.settings);
        Map<String, Object> operatorPrivilegesUsage = Map.of("available", Security.OPERATOR_PRIVILEGES_FEATURE.checkWithoutTracking(this.licenseState), "enabled", OperatorPrivileges.OPERATOR_PRIVILEGES_ENABLED.get(this.settings));
        AtomicReference rolesUsageRef = new AtomicReference(Map.of());
        AtomicReference roleMappingUsageRef = new AtomicReference(Map.of());
        AtomicReference realmsUsageRef = new AtomicReference(Map.of());
        AtomicReference domainsUsageRef = new AtomicReference(Map.of());
        AtomicReference userProfileUsageRef = new AtomicReference(Map.of());
        AtomicReference remoteClusterServerUsageRef = new AtomicReference(Map.of());
        boolean enabled = (Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings);
        try (RefCountingListener listeners = new RefCountingListener(listener.map(ignored -> new XPackUsageFeatureResponse((XPackFeatureUsage)new SecurityFeatureSetUsage(enabled, (Map)realmsUsageRef.get(), (Map)rolesUsageRef.get(), (Map)roleMappingUsageRef.get(), sslUsage, auditUsage, ipFilterUsage, anonymousUsage, tokenServiceUsage, apiKeyServiceUsage, fips140Usage, operatorPrivilegesUsage, (Map)domainsUsageRef.get(), (Map)userProfileUsageRef.get(), (Map)remoteClusterServerUsageRef.get()))));){
            if (!enabled) {
                return;
            }
            if (this.rolesStore != null) {
                this.rolesStore.usageStats((ActionListener<Map<String, Object>>)listeners.acquire(rolesUsageRef::set));
            }
            if (this.roleMappingStore != null) {
                this.roleMappingStore.usageStats((ActionListener<Map<String, Object>>)listeners.acquire(nativeRoleMappingStoreUsage -> roleMappingUsageRef.set(Map.of("native", nativeRoleMappingStoreUsage))));
            }
            if (this.realms != null) {
                domainsUsageRef.set(this.realms.domainUsageStats());
                this.realms.usageStats((ActionListener<Map<String, Object>>)listeners.acquire(realmsUsageRef::set));
            }
            if (this.profileService != null) {
                this.profileService.usageStats((ActionListener<Map<String, Object>>)listeners.acquire(userProfileUsageRef::set));
            }
            if (this.apiKeyService != null) {
                this.apiKeyService.crossClusterApiKeyUsageStats((ActionListener<Map<String, Object>>)listeners.acquire(usage -> remoteClusterServerUsageRef.set(Map.of("available", Security.ADVANCED_REMOTE_CLUSTER_SECURITY_FEATURE.checkWithoutTracking(this.licenseState), "enabled", RemoteClusterPortSettings.REMOTE_CLUSTER_SERVER_ENABLED.get(this.settings), "api_keys", usage))));
            }
        }
    }

    static Map<String, Object> sslUsage(Settings settings) {
        if (((Boolean)XPackSettings.SECURITY_ENABLED.get(settings)).booleanValue()) {
            Map map = Maps.newMapWithExpectedSize((int)2);
            map.put("http", Collections.singletonMap("enabled", (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings)));
            map.put("transport", Collections.singletonMap("enabled", (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings)));
            if (((Boolean)RemoteClusterPortSettings.REMOTE_CLUSTER_SERVER_ENABLED.get(settings)).booleanValue()) {
                map.put("remote_cluster_server", Collections.singletonMap("enabled", (Boolean)XPackSettings.REMOTE_CLUSTER_SERVER_SSL_ENABLED.get(settings)));
            }
            map.put("remote_cluster_client", Collections.singletonMap("enabled", (Boolean)XPackSettings.REMOTE_CLUSTER_CLIENT_SSL_ENABLED.get(settings)));
            return map;
        }
        return Collections.emptyMap();
    }

    static Map<String, Object> tokenServiceUsage(Settings settings) {
        return Collections.singletonMap("enabled", XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.get(settings));
    }

    static Map<String, Object> apiKeyServiceUsage(Settings settings) {
        return Collections.singletonMap("enabled", XPackSettings.API_KEY_SERVICE_ENABLED_SETTING.get(settings));
    }

    static Map<String, Object> auditUsage(Settings settings) {
        Map map = Maps.newMapWithExpectedSize((int)2);
        map.put("enabled", XPackSettings.AUDIT_ENABLED.get(settings));
        if (((Boolean)XPackSettings.AUDIT_ENABLED.get(settings)).booleanValue()) {
            map.put("outputs", Arrays.asList("logfile"));
        }
        return map;
    }

    static Map<String, Object> ipFilterUsage(@Nullable IPFilter ipFilter) {
        if (ipFilter == null) {
            return IPFilter.DISABLED_USAGE_STATS;
        }
        return ipFilter.usageStats();
    }

    static Map<String, Object> fips140Usage(Settings settings) {
        return Collections.singletonMap("enabled", XPackSettings.FIPS_MODE_ENABLED.get(settings));
    }
}

