/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.service;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.service.ServiceAccountInfo;

public class GetServiceAccountResponse
extends ActionResponse
implements ToXContentObject {
    private final ServiceAccountInfo[] serviceAccountInfos;

    public GetServiceAccountResponse(ServiceAccountInfo[] serviceAccountInfos) {
        this.serviceAccountInfos = Objects.requireNonNull(serviceAccountInfos);
    }

    public GetServiceAccountResponse(StreamInput in) throws IOException {
        this.serviceAccountInfos = (ServiceAccountInfo[])in.readArray(ServiceAccountInfo::new, ServiceAccountInfo[]::new);
    }

    public ServiceAccountInfo[] getServiceAccountInfos() {
        return this.serviceAccountInfos;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray((Writeable[])this.serviceAccountInfos);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (ServiceAccountInfo info : this.serviceAccountInfos) {
            info.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "GetServiceAccountResponse{serviceAccountInfos=" + Arrays.toString(this.serviceAccountInfos) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetServiceAccountResponse that = (GetServiceAccountResponse)((Object)o);
        return Arrays.equals(this.serviceAccountInfos, that.serviceAccountInfos);
    }

    public int hashCode() {
        return Arrays.hashCode(this.serviceAccountInfos);
    }
}

