/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.TriConsumer;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class AsyncBranchingStep
extends AsyncActionStep {
    public static final String NAME = "branch";
    private final Step.StepKey nextStepKeyOnFalse;
    private final Step.StepKey nextStepKeyOnTrue;
    private final TriConsumer<ProjectId, IndexMetadata, ActionListener<Boolean>> asyncPredicate;
    private final SetOnce<Boolean> predicateValue;

    public AsyncBranchingStep(Step.StepKey key, Step.StepKey nextStepKeyOnFalse, Step.StepKey nextStepKeyOnTrue, TriConsumer<ProjectId, IndexMetadata, ActionListener<Boolean>> asyncPredicate, Client client) {
        super(key, null, client);
        this.nextStepKeyOnFalse = nextStepKeyOnFalse;
        this.nextStepKeyOnTrue = nextStepKeyOnTrue;
        this.asyncPredicate = asyncPredicate;
        this.predicateValue = new SetOnce();
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ProjectState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        this.asyncPredicate.apply((Object)currentState.projectId(), (Object)indexMetadata, (Object)listener.safeMap(value -> {
            this.predicateValue.set(value);
            return null;
        }));
    }

    @Override
    public final Step.StepKey getNextStepKey() {
        if (this.predicateValue.get() == null) {
            throw new IllegalStateException("Cannot call getNextStepKey before performAction");
        }
        return (Boolean)this.predicateValue.get() != false ? this.nextStepKeyOnTrue : this.nextStepKeyOnFalse;
    }

    final Step.StepKey getNextStepKeyOnFalse() {
        return this.nextStepKeyOnFalse;
    }

    final Step.StepKey getNextStepKeyOnTrue() {
        return this.nextStepKeyOnTrue;
    }

    final TriConsumer<ProjectId, IndexMetadata, ActionListener<Boolean>> getAsyncPredicate() {
        return this.asyncPredicate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AsyncBranchingStep that = (AsyncBranchingStep)o;
        return super.equals(o) && Objects.equals(this.nextStepKeyOnFalse, that.nextStepKeyOnFalse) && Objects.equals(this.nextStepKeyOnTrue, that.nextStepKeyOnTrue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nextStepKeyOnFalse, this.nextStepKeyOnTrue);
    }
}

