/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.h3;

import org.elasticsearch.h3.BaseCells;
import org.elasticsearch.h3.CoordIJK;
import org.elasticsearch.h3.FaceIJK;

final class H3Index {
    public static final long H3_INIT = 0x1FFFFFFFFFFFL;
    public static final int H3_MODE_OFFSET = 59;
    public static final long H3_MODE_MASK = 0x7800000000000000L;
    public static final long H3_MODE_MASK_NEGATIVE = -8646911284551352321L;
    public static final int H3_BC_OFFSET = 45;
    public static final long H3_BC_MASK = 0xFE00000000000L;
    public static final long H3_BC_MASK_NEGATIVE = -4468415255281665L;
    public static final int H3_RES_OFFSET = 52;
    public static final long H3_RES_MASK = 0xF0000000000000L;
    public static final long H3_RES_MASK_NEGATIVE = -67553994410557441L;
    public static final int H3_MAX_OFFSET = 63;
    public static final long H3_HIGH_BIT_MASK = Long.MIN_VALUE;
    public static final int H3_RESERVED_OFFSET = 56;
    public static final long H3_RESERVED_MASK = 0x700000000000000L;
    public static final int H3_PER_DIGIT_OFFSET = 3;
    public static final long H3_DIGIT_MASK = 7L;

    H3Index() {
    }

    public static int H3_get_base_cell(long h3) {
        return (int)((h3 & 0xFE00000000000L) >> 45);
    }

    public static boolean H3_is_pentagon(long h3) {
        return BaseCells.isBaseCellPentagon(H3Index.H3_get_base_cell(h3)) && H3Index.h3LeadingNonZeroDigit(h3) == 0;
    }

    public static long H3_set_mode(long h3, long mode) {
        return h3 & 0x87FFFFFFFFFFFFFFL | mode << 59;
    }

    public static long H3_set_base_cell(long h3, long bc) {
        return h3 & 0xFFF01FFFFFFFFFFFL | bc << 45;
    }

    public static int H3_get_high_bit(long h3) {
        return (int)((h3 & Long.MIN_VALUE) >> 63);
    }

    public static long H3_set_resolution(long h3, long res) {
        return h3 & 0xFF0FFFFFFFFFFFFFL | res << 52;
    }

    public static int H3_get_reserved_bits(long h3) {
        return (int)((h3 & 0x700000000000000L) >> 56);
    }

    public static int H3_get_mode(long h3) {
        return (int)((h3 & 0x7800000000000000L) >> 59);
    }

    public static int H3_get_resolution(long h3) {
        return (int)((h3 & 0xF0000000000000L) >> 52);
    }

    public static int H3_get_index_digit(long h3, int res) {
        return (int)(h3 >> (15 - res) * 3 & 7L);
    }

    public static long H3_set_index_digit(long h3, int res, long digit) {
        int x = (15 - res) * 3;
        return h3 & (7L << x ^ 0xFFFFFFFFFFFFFFFFL) | digit << x;
    }

    public static boolean isResolutionClassIII(int res) {
        return (res & 1) == 1;
    }

    public static FaceIJK h3ToFaceIjk(long h3) {
        boolean pentLeading4;
        FaceIJK fijk;
        int baseCell = H3Index.H3_get_base_cell(h3);
        if (baseCell < 0 || baseCell >= 122) {
            throw new IllegalArgumentException();
        }
        if (BaseCells.isBaseCellPentagon(baseCell) && H3Index.h3LeadingNonZeroDigit(h3) == 5) {
            h3 = H3Index.h3Rotate60cw(h3);
        }
        if (!H3Index.h3ToFaceIjkWithInitializedFijk(h3, fijk = BaseCells.getBaseFaceIJK(baseCell))) {
            return fijk;
        }
        int origI = fijk.coord.i;
        int origJ = fijk.coord.j;
        int origK = fijk.coord.k;
        int res = H3Index.H3_get_resolution(h3);
        if (H3Index.isResolutionClassIII(res)) {
            fijk.coord.downAp7r();
            ++res;
        }
        boolean bl = pentLeading4 = BaseCells.isBaseCellPentagon(baseCell) && H3Index.h3LeadingNonZeroDigit(h3) == 4;
        if (fijk.adjustOverageClassII(res, pentLeading4, false) != FaceIJK.Overage.NO_OVERAGE) {
            if (BaseCells.isBaseCellPentagon(baseCell)) {
                FaceIJK.Overage overage;
                while ((overage = fijk.adjustOverageClassII(res, false, false)) != FaceIJK.Overage.NO_OVERAGE) {
                }
            }
            if (res != H3Index.H3_get_resolution(h3)) {
                fijk.coord.upAp7r();
            }
        } else if (res != H3Index.H3_get_resolution(h3)) {
            fijk.coord.reset(origI, origJ, origK);
        }
        return fijk;
    }

    public static int h3LeadingNonZeroDigit(long h) {
        for (int r = 1; r <= H3Index.H3_get_resolution(h); ++r) {
            int dir = H3Index.H3_get_index_digit(h, r);
            if (dir == CoordIJK.Direction.CENTER_DIGIT.digit()) continue;
            return dir;
        }
        return CoordIJK.Direction.CENTER_DIGIT.digit();
    }

    private static boolean h3ToFaceIjkWithInitializedFijk(long h, FaceIJK fijk) {
        int res = H3Index.H3_get_resolution(h);
        boolean possibleOverage = BaseCells.isBaseCellPentagon(H3Index.H3_get_base_cell(h)) || res != 0 && (fijk.coord.i != 0 || fijk.coord.j != 0 || fijk.coord.k != 0);
        for (int r = 1; r <= res; ++r) {
            if (H3Index.isResolutionClassIII(r)) {
                fijk.coord.downAp7();
            } else {
                fijk.coord.downAp7r();
            }
            fijk.coord.neighbor(H3Index.H3_get_index_digit(h, r));
        }
        return possibleOverage;
    }

    public static long h3Rotate60cw(long h) {
        int res = H3Index.H3_get_resolution(h);
        for (int r = 1; r <= res; ++r) {
            h = H3Index.H3_set_index_digit(h, r, CoordIJK.rotate60cw(H3Index.H3_get_index_digit(h, r)));
        }
        return h;
    }

    public static long h3Rotate60ccw(long h) {
        int res = H3Index.H3_get_resolution(h);
        for (int r = 1; r <= res; ++r) {
            h = H3Index.H3_set_index_digit(h, r, CoordIJK.rotate60ccw(H3Index.H3_get_index_digit(h, r)));
        }
        return h;
    }

    public static long h3RotatePent60ccw(long h) {
        boolean foundFirstNonZeroDigit = false;
        int res = H3Index.H3_get_resolution(h);
        for (int r = 1; r <= res; ++r) {
            h = H3Index.H3_set_index_digit(h, r, CoordIJK.rotate60ccw(H3Index.H3_get_index_digit(h, r)));
            if (foundFirstNonZeroDigit || H3Index.H3_get_index_digit(h, r) == 0) continue;
            foundFirstNonZeroDigit = true;
            if (H3Index.h3LeadingNonZeroDigit(h) != CoordIJK.Direction.K_AXES_DIGIT.digit()) continue;
            h = H3Index.h3Rotate60ccw(h);
        }
        return h;
    }
}

