/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication;

import java.util.Date;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.shared.common.error.ErrorStringBuilder;

public class ReplicationLogger {
    private final boolean verbose = PropertyUtil.getSystemBoolean("derby.replication.verbose", true);
    private final String dbname;

    public ReplicationLogger(String dbname) {
        this.dbname = dbname;
    }

    public void logError(String msgId, Throwable t) {
        if (this.verbose) {
            Monitor.logTextMessage("R001", new Date());
            if (msgId != null) {
                Monitor.logTextMessage(msgId, this.dbname);
            }
            if (t != null) {
                ErrorStringBuilder esb = new ErrorStringBuilder(Monitor.getStream().getHeader());
                esb.stackTrace(t);
                Monitor.logMessage(esb.get().toString());
                esb.reset();
            }
            Monitor.logTextMessage("R002", new Object[0]);
        }
    }

    public void logText(String text, boolean writeHeader) {
        if (this.verbose) {
            if (writeHeader) {
                Monitor.logTextMessage("R001", new Date());
                Monitor.logMessage(text);
                Monitor.logTextMessage("R002", new Object[0]);
            } else {
                Monitor.logTextMessage("R013", new Date(), text);
            }
        }
    }
}

