/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricExt;

@JRubyClass(name={"NamespacedMetric"})
public final class NamespacedMetricExt
extends AbstractNamespacedMetricExt {
    private static final long serialVersionUID = 1L;
    private RubyArray namespaceName;
    private MetricExt metric;

    public static NamespacedMetricExt create(MetricExt metric, RubyArray namespaceName) {
        NamespacedMetricExt res = new NamespacedMetricExt(RubyUtil.RUBY, RubyUtil.NAMESPACED_METRIC_CLASS);
        res.metric = metric;
        res.namespaceName = namespaceName;
        return res;
    }

    public NamespacedMetricExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public NamespacedMetricExt initialize(ThreadContext context, IRubyObject metric, IRubyObject namespaceName) {
        this.metric = (MetricExt)metric;
        this.namespaceName = this.normalizeNamespace(namespaceName);
        return this;
    }

    @Override
    protected IRubyObject getCollector(ThreadContext context) {
        return this.metric.collector(context);
    }

    @Override
    protected IRubyObject getCounter(ThreadContext context, IRubyObject key) {
        return this.collector(context).callMethod(context, "get", new IRubyObject[]{this.namespaceName, key, MetricExt.COUNTER});
    }

    @Override
    protected IRubyObject getGauge(ThreadContext context, IRubyObject key, IRubyObject value) {
        return this.metric.gauge(context, (IRubyObject)this.namespaceName, key, value);
    }

    @Override
    protected IRubyObject getTimer(ThreadContext context, IRubyObject key) {
        return this.metric.timer(context, (IRubyObject)this.namespaceName, key);
    }

    @Override
    protected IRubyObject doIncrement(ThreadContext context, IRubyObject[] args) {
        if (args.length == 1) {
            return this.metric.increment(context, (IRubyObject)this.namespaceName, args[0]);
        }
        return this.metric.increment(context, (IRubyObject)this.namespaceName, args[0], args[1]);
    }

    @Override
    protected IRubyObject doDecrement(ThreadContext context, IRubyObject[] args) {
        if (args.length == 1) {
            return this.metric.decrement(context, (IRubyObject)this.namespaceName, args[0]);
        }
        return this.metric.decrement(context, (IRubyObject)this.namespaceName, args[0], args[1]);
    }

    @Override
    protected IRubyObject doTime(ThreadContext context, IRubyObject key, Block block) {
        return this.metric.time(context, (IRubyObject)this.namespaceName, key, block);
    }

    @Override
    protected IRubyObject doReportTime(ThreadContext context, IRubyObject key, IRubyObject duration) {
        return this.metric.reportTime(context, (IRubyObject)this.namespaceName, key, duration);
    }

    @Override
    protected RubyArray getNamespaceName(ThreadContext context) {
        return this.namespaceName;
    }

    @Override
    protected NamespacedMetricExt createNamespaced(ThreadContext context, IRubyObject name) {
        MetricExt.validateName(context, name, RubyUtil.METRIC_NO_NAMESPACE_PROVIDED_CLASS);
        return NamespacedMetricExt.create(this.metric, (RubyArray)this.namespaceName.op_plus((IRubyObject)this.normalizeNamespace(name)));
    }

    @Override
    public AbstractMetricExt getMetric() {
        return this.metric;
    }
}

