/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Build;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.support.CountDownActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.indices.IndicesExpressionGrouper;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteClusterAwareClient;
import org.elasticsearch.transport.RemoteClusterConnection;
import org.elasticsearch.transport.RemoteClusterCredentialsManager;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.transport.RemoteClusterServerInfo;
import org.elasticsearch.transport.RemoteConnectionInfo;
import org.elasticsearch.transport.RemoteConnectionStrategy;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;

public final class RemoteClusterService
extends RemoteClusterAware
implements Closeable,
ReportingService<RemoteClusterServerInfo>,
IndicesExpressionGrouper {
    private static final Logger logger = LogManager.getLogger(RemoteClusterService.class);
    public static final Setting<TimeValue> REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING = Setting.positiveTimeSetting("cluster.remote.initial_connect_timeout", TimeValue.timeValueSeconds(30L), Setting.Property.NodeScope);
    public static final Setting<String> REMOTE_NODE_ATTRIBUTE = Setting.simpleString("cluster.remote.node.attr", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<Boolean> REMOTE_CLUSTER_SKIP_UNAVAILABLE = Setting.affixKeySetting("cluster.remote.", "skip_unavailable", (ns, key) -> Setting.boolSetting(key, true, new RemoteConnectionEnabled<Boolean>((String)ns, (String)key), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> REMOTE_CLUSTER_PING_SCHEDULE = Setting.affixKeySetting("cluster.remote.", "transport.ping_schedule", (ns, key) -> Setting.timeSetting(key, TransportSettings.PING_SCHEDULE, new RemoteConnectionEnabled<TimeValue>((String)ns, (String)key), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Compression.Enabled> REMOTE_CLUSTER_COMPRESS = Setting.affixKeySetting("cluster.remote.", "transport.compress", (ns, key) -> Setting.enumSetting(Compression.Enabled.class, key, TransportSettings.TRANSPORT_COMPRESS, new RemoteConnectionEnabled((String)ns, (String)key), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Compression.Scheme> REMOTE_CLUSTER_COMPRESSION_SCHEME = Setting.affixKeySetting("cluster.remote.", "transport.compression_scheme", (ns, key) -> Setting.enumSetting(Compression.Scheme.class, key, TransportSettings.TRANSPORT_COMPRESSION_SCHEME, new RemoteConnectionEnabled((String)ns, (String)key), Setting.Property.Dynamic, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<SecureString> REMOTE_CLUSTER_CREDENTIALS = Setting.affixKeySetting("cluster.remote.", "credentials", key -> SecureSetting.secureString(key, null, new Setting.Property[0]), new Setting.AffixSettingDependency[0]);
    public static final String REMOTE_CLUSTER_HANDSHAKE_ACTION_NAME = "cluster:internal/remote_cluster/handshake";
    private final boolean enabled;
    private final boolean remoteClusterServerEnabled;
    private final TransportService transportService;
    private final Map<String, RemoteClusterConnection> remoteClusters = ConcurrentCollections.newConcurrentMap();
    private final RemoteClusterCredentialsManager remoteClusterCredentialsManager;

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRemoteClusterServerEnabled() {
        return this.remoteClusterServerEnabled;
    }

    RemoteClusterService(Settings settings, TransportService transportService) {
        super(settings);
        this.enabled = DiscoveryNode.isRemoteClusterClient(settings);
        this.remoteClusterServerEnabled = RemoteClusterPortSettings.REMOTE_CLUSTER_SERVER_ENABLED.get(settings);
        this.transportService = transportService;
        this.remoteClusterCredentialsManager = new RemoteClusterCredentialsManager(settings);
        if (this.remoteClusterServerEnabled) {
            RemoteClusterService.registerRemoteClusterHandshakeRequestHandler(transportService);
        }
    }

    public DiscoveryNode getLocalNode() {
        return this.transportService.getLocalNode();
    }

    public boolean isCrossClusterSearchEnabled() {
        return !this.remoteClusters.isEmpty();
    }

    boolean isRemoteNodeConnected(String remoteCluster, DiscoveryNode node) {
        return this.remoteClusters.get(remoteCluster).isNodeConnected(node);
    }

    public Map<String, OriginalIndices> groupIndices(Set<String> remoteClusterNames, IndicesOptions indicesOptions, String[] indices, boolean returnLocalAll) {
        HashMap<String, OriginalIndices> originalIndicesMap = new HashMap<String, OriginalIndices>();
        Map<Object, Object> groupedIndices = !returnLocalAll && IndexNameExpressionResolver.isNoneExpression(indices) ? Map.of() : this.groupClusterIndices(remoteClusterNames, indices);
        if (groupedIndices.isEmpty()) {
            if (returnLocalAll) {
                originalIndicesMap.put("", new OriginalIndices(Strings.EMPTY_ARRAY, indicesOptions));
            }
        } else {
            for (Map.Entry<Object, Object> entry : groupedIndices.entrySet()) {
                String clusterAlias = (String)entry.getKey();
                List originalIndices = (List)entry.getValue();
                originalIndicesMap.put(clusterAlias, new OriginalIndices(originalIndices.toArray(new String[0]), indicesOptions));
            }
        }
        return originalIndicesMap;
    }

    @Override
    public Map<String, OriginalIndices> groupIndices(Set<String> remoteClusterNames, IndicesOptions indicesOptions, String[] indices) {
        return this.groupIndices(remoteClusterNames, indicesOptions, indices, true);
    }

    public Map<String, OriginalIndices> groupIndices(IndicesOptions indicesOptions, String[] indices, boolean returnLocalAll) {
        return this.groupIndices(this.getRemoteClusterNames(), indicesOptions, indices, returnLocalAll);
    }

    public Map<String, OriginalIndices> groupIndices(IndicesOptions indicesOptions, String[] indices) {
        return this.groupIndices(this.getRemoteClusterNames(), indicesOptions, indices, true);
    }

    @Override
    public Set<String> getConfiguredClusters() {
        return this.getRemoteClusterNames();
    }

    boolean isRemoteClusterRegistered(String clusterName) {
        return this.remoteClusters.containsKey(clusterName);
    }

    public Set<String> getRegisteredRemoteClusterNames() {
        return this.remoteClusters.keySet();
    }

    public Transport.Connection getConnection(DiscoveryNode node, String cluster) {
        return this.getRemoteClusterConnection(cluster).getConnection(node);
    }

    void ensureConnected(String clusterAlias, ActionListener<Void> listener) {
        RemoteClusterConnection remoteClusterConnection;
        try {
            remoteClusterConnection = this.getRemoteClusterConnection(clusterAlias);
        }
        catch (NoSuchRemoteClusterException e) {
            listener.onFailure(e);
            return;
        }
        remoteClusterConnection.ensureConnected(listener);
    }

    public boolean isSkipUnavailable(String clusterAlias) {
        return this.getRemoteClusterConnection(clusterAlias).isSkipUnavailable();
    }

    public Transport.Connection getConnection(String cluster) {
        return this.getRemoteClusterConnection(cluster).getConnection();
    }

    public void maybeEnsureConnectedAndGetConnection(String clusterAlias, boolean ensureConnected, ActionListener<Transport.Connection> listener) {
        ActionListener<Void> ensureConnectedListener = listener.delegateFailureAndWrap((l, nullValue) -> ActionListener.completeWith(l, () -> {
            try {
                return this.getConnection(clusterAlias);
            }
            catch (ConnectTransportException e) {
                if (!ensureConnected) {
                    this.ensureConnected(clusterAlias, ActionListener.noop());
                }
                throw e;
            }
        }));
        if (ensureConnected) {
            this.ensureConnected(clusterAlias, ensureConnectedListener);
        } else {
            ensureConnectedListener.onResponse(null);
        }
    }

    public RemoteClusterConnection getRemoteClusterConnection(String cluster) {
        if (!this.enabled) {
            throw new IllegalArgumentException("this node does not have the " + DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE.roleName() + " role");
        }
        RemoteClusterConnection connection = this.remoteClusters.get(cluster);
        if (connection == null) {
            throw new NoSuchRemoteClusterException(cluster);
        }
        return connection;
    }

    Set<String> getRemoteClusterNames() {
        return this.remoteClusters.keySet();
    }

    @Override
    public void listenForUpdates(ClusterSettings clusterSettings) {
        super.listenForUpdates(clusterSettings);
        clusterSettings.addAffixUpdateConsumer(REMOTE_CLUSTER_SKIP_UNAVAILABLE, this::updateSkipUnavailable, (alias, value) -> {});
    }

    private synchronized void updateSkipUnavailable(String clusterAlias, Boolean skipUnavailable) {
        RemoteClusterConnection remote = this.remoteClusters.get(clusterAlias);
        if (remote != null) {
            remote.setSkipUnavailable(skipUnavailable);
        }
    }

    public synchronized void updateRemoteClusterCredentials(Supplier<Settings> settingsSupplier, ActionListener<Void> listener) {
        Settings settings = settingsSupplier.get();
        RemoteClusterCredentialsManager.UpdateRemoteClusterCredentialsResult result = this.remoteClusterCredentialsManager.updateClusterCredentials(settings);
        int totalConnectionsToRebuild = result.addedClusterAliases().size() + result.removedClusterAliases().size();
        if (totalConnectionsToRebuild == 0) {
            logger.debug("no connection rebuilding required after credentials update");
            listener.onResponse(null);
            return;
        }
        logger.info("rebuilding [{}] connections after credentials update", (Object)totalConnectionsToRebuild);
        try (RefCountingRunnable connectionRefs = new RefCountingRunnable(() -> listener.onResponse(null));){
            for (String clusterAlias : result.addedClusterAliases()) {
                this.maybeRebuildConnectionOnCredentialsChange(clusterAlias, settings, connectionRefs);
            }
            for (String clusterAlias : result.removedClusterAliases()) {
                this.maybeRebuildConnectionOnCredentialsChange(clusterAlias, settings, connectionRefs);
            }
        }
    }

    private void maybeRebuildConnectionOnCredentialsChange(final String clusterAlias, Settings settings, RefCountingRunnable connectionRefs) {
        if (!this.remoteClusters.containsKey(clusterAlias)) {
            logger.info("no connection rebuild required for remote cluster [{}] after credentials change", (Object)clusterAlias);
            return;
        }
        this.updateRemoteCluster(clusterAlias, settings, true, ActionListener.releaseAfter(new ActionListener<RemoteClusterConnectionStatus>(this){

            @Override
            public void onResponse(RemoteClusterConnectionStatus status) {
                logger.info("remote cluster connection [{}] updated after credentials change: [{}]", (Object)clusterAlias, (Object)status);
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> "failed to update remote cluster connection [" + clusterAlias + "] after credentials change", (Throwable)e);
            }
        }, connectionRefs.acquire()));
    }

    @Override
    protected void updateRemoteCluster(final String clusterAlias, Settings settings) {
        CountDownLatch latch = new CountDownLatch(1);
        this.updateRemoteCluster(clusterAlias, settings, ActionListener.runAfter(new ActionListener<RemoteClusterConnectionStatus>(this){

            @Override
            public void onResponse(RemoteClusterConnectionStatus status) {
                logger.info("remote cluster connection [{}] updated: {}", (Object)clusterAlias, (Object)status);
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> "failed to update remote cluster connection [" + clusterAlias + "]", (Throwable)e);
            }
        }, latch::countDown));
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                logger.warn("failed to update remote cluster connection [{}] within {}", (Object)clusterAlias, (Object)TimeValue.timeValueSeconds(10L));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    void updateRemoteCluster(String clusterAlias, Settings newSettings, ActionListener<RemoteClusterConnectionStatus> listener) {
        this.updateRemoteCluster(clusterAlias, newSettings, false, listener);
    }

    private synchronized void updateRemoteCluster(String clusterAlias, Settings newSettings, boolean forceRebuild, ActionListener<RemoteClusterConnectionStatus> listener) {
        if ("".equals(clusterAlias)) {
            throw new IllegalArgumentException("remote clusters must not have the empty string as its key");
        }
        RemoteClusterConnection remote = this.remoteClusters.get(clusterAlias);
        if (!RemoteConnectionStrategy.isConnectionEnabled(clusterAlias, newSettings)) {
            try {
                IOUtils.close((Closeable)remote);
            }
            catch (IOException e) {
                logger.warn("failed to close remote cluster connections for cluster: " + clusterAlias, (Throwable)e);
            }
            this.remoteClusters.remove(clusterAlias);
            listener.onResponse(RemoteClusterConnectionStatus.DISCONNECTED);
            return;
        }
        if (remote == null) {
            Settings finalSettings = Settings.builder().put(this.settings, false).put(newSettings, false).build();
            remote = new RemoteClusterConnection(finalSettings, clusterAlias, this.transportService, this.remoteClusterCredentialsManager);
            this.remoteClusters.put(clusterAlias, remote);
            remote.ensureConnected(listener.map(ignored -> RemoteClusterConnectionStatus.CONNECTED));
        } else if (forceRebuild || remote.shouldRebuildConnection(newSettings)) {
            try {
                IOUtils.close((Closeable)remote);
            }
            catch (IOException e) {
                logger.warn("failed to close remote cluster connections for cluster: " + clusterAlias, (Throwable)e);
            }
            this.remoteClusters.remove(clusterAlias);
            Settings finalSettings = Settings.builder().put(this.settings, false).put(newSettings, false).build();
            remote = new RemoteClusterConnection(finalSettings, clusterAlias, this.transportService, this.remoteClusterCredentialsManager);
            this.remoteClusters.put(clusterAlias, remote);
            remote.ensureConnected(listener.map(ignored -> RemoteClusterConnectionStatus.RECONNECTED));
        } else {
            listener.onResponse(RemoteClusterConnectionStatus.UNCHANGED);
        }
    }

    void initializeRemoteClusters() {
        TimeValue timeValue = REMOTE_INITIAL_CONNECTION_TIMEOUT_SETTING.get(this.settings);
        PlainActionFuture<Void> future = new PlainActionFuture<Void>();
        Set<String> enabledClusters = RemoteClusterAware.getEnabledRemoteClusters(this.settings);
        if (enabledClusters.isEmpty()) {
            return;
        }
        CountDownActionListener listener = new CountDownActionListener(enabledClusters.size(), future);
        for (String clusterAlias : enabledClusters) {
            this.updateRemoteCluster(clusterAlias, this.settings, listener.map(ignored -> null));
        }
        if (enabledClusters.isEmpty()) {
            future.onResponse(null);
        }
        try {
            future.get(timeValue.millis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException ex) {
            logger.warn("failed to connect to remote clusters within {}", (Object)timeValue.toString());
        }
        catch (Exception e) {
            logger.warn("failed to connect to remote clusters", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.remoteClusters.values());
    }

    public Stream<RemoteConnectionInfo> getRemoteConnectionInfos() {
        return this.remoteClusters.values().stream().map(RemoteClusterConnection::getConnectionInfo);
    }

    @Override
    public RemoteClusterServerInfo info() {
        if (this.remoteClusterServerEnabled) {
            return new RemoteClusterServerInfo(this.transportService.boundRemoteAccessAddress());
        }
        return null;
    }

    public void collectNodes(Set<String> clusters, final ActionListener<BiFunction<String, String, DiscoveryNode>> listener) {
        if (!this.enabled) {
            throw new IllegalArgumentException("this node does not have the " + DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE.roleName() + " role");
        }
        for (String cluster : clusters) {
            if (this.remoteClusters.containsKey(cluster)) continue;
            listener.onFailure(new NoSuchRemoteClusterException(cluster));
            return;
        }
        final HashMap clusterMap = new HashMap();
        final CountDown countDown = new CountDown(clusters.size());
        final Function<String, DiscoveryNode> nullFunction = s -> null;
        for (final String cluster : clusters) {
            RemoteClusterConnection connection = this.remoteClusters.get(cluster);
            connection.collectNodes(new ActionListener<Function<String, DiscoveryNode>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(Function<String, DiscoveryNode> nodeLookup) {
                    Map map = clusterMap;
                    synchronized (map) {
                        clusterMap.put(cluster, nodeLookup);
                    }
                    if (countDown.countDown()) {
                        listener.onResponse((clusterAlias, nodeId) -> (DiscoveryNode)clusterMap.getOrDefault(clusterAlias, nullFunction).apply(nodeId));
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    if (countDown.fastForward()) {
                        listener.onFailure(e);
                    }
                }
            });
        }
    }

    public RemoteClusterClient getRemoteClusterClient(String clusterAlias, Executor responseExecutor, DisconnectedStrategy disconnectedStrategy) {
        if (!this.transportService.getRemoteClusterService().isEnabled()) {
            throw new IllegalArgumentException("this node does not have the " + DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE.roleName() + " role");
        }
        if (!this.transportService.getRemoteClusterService().getRemoteClusterNames().contains(clusterAlias)) {
            throw new NoSuchRemoteClusterException(clusterAlias);
        }
        return new RemoteClusterAwareClient(this.transportService, clusterAlias, responseExecutor, switch (disconnectedStrategy.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> false;
            case 2 -> !this.transportService.getRemoteClusterService().isSkipUnavailable(clusterAlias);
        });
    }

    Collection<RemoteClusterConnection> getConnections() {
        return this.remoteClusters.values();
    }

    static void registerRemoteClusterHandshakeRequestHandler(TransportService transportService) {
        transportService.registerRequestHandler(REMOTE_CLUSTER_HANDSHAKE_ACTION_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, false, false, TransportService.HandshakeRequest::new, (request, channel, task) -> {
            if (!"_remote_cluster".equals(channel.getProfileName())) {
                throw new IllegalArgumentException(Strings.format("remote cluster handshake action requires channel profile to be [%s], but got [%s]", "_remote_cluster", channel.getProfileName()));
            }
            logger.trace("handling remote cluster handshake request");
            channel.sendResponse(new TransportService.HandshakeResponse(transportService.getLocalNode().getVersion(), Build.current().hash(), transportService.getLocalNode().withTransportAddress(transportService.boundRemoteAccessAddress().publishAddress()), transportService.clusterName));
        });
    }

    static enum RemoteClusterConnectionStatus {
        CONNECTED,
        DISCONNECTED,
        RECONNECTED,
        UNCHANGED;

    }

    public static enum DisconnectedStrategy {
        RECONNECT_IF_DISCONNECTED,
        FAIL_IF_DISCONNECTED,
        RECONNECT_UNLESS_SKIP_UNAVAILABLE;

    }

    private static class RemoteConnectionEnabled<T>
    implements Setting.Validator<T> {
        private final String clusterAlias;
        private final String key;

        private RemoteConnectionEnabled(String clusterAlias, String key) {
            this.clusterAlias = clusterAlias;
            this.key = key;
        }

        @Override
        public void validate(T value) {
        }

        @Override
        public void validate(T value, Map<Setting<?>, Object> settings, boolean isPresent) {
            if (isPresent && !RemoteConnectionStrategy.isConnectionEnabled(this.clusterAlias, settings)) {
                throw new IllegalArgumentException("Cannot configure setting [" + this.key + "] if remote cluster is not enabled.");
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            return Stream.concat(Stream.of(RemoteConnectionStrategy.REMOTE_CONNECTION_MODE.getConcreteSettingForNamespace(this.clusterAlias)), this.settingsStream()).iterator();
        }

        private Stream<Setting<?>> settingsStream() {
            return Arrays.stream(RemoteConnectionStrategy.ConnectionStrategy.values()).flatMap(strategy -> strategy.getEnablementSettings().get()).map(as -> as.getConcreteSettingForNamespace(this.clusterAlias));
        }
    }
}

