/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.ingest.IngestMetric;
import org.elasticsearch.ingest.IngestStats;

public class IngestPipelineMetric
extends IngestMetric {
    private final CounterMetric bytesIngested = new CounterMetric();
    private final CounterMetric bytesProduced = new CounterMetric();

    void add(IngestPipelineMetric metrics) {
        super.add(metrics);
        this.bytesIngested.inc(metrics.bytesIngested.count());
        this.bytesProduced.inc(metrics.bytesProduced.count());
    }

    void preIngestBytes(long bytesIngested) {
        this.bytesIngested.inc(bytesIngested);
    }

    void postIngestBytes(long bytesProduced) {
        this.bytesProduced.inc(bytesProduced);
    }

    IngestStats.ByteStats createByteStats() {
        long bytesIngested = this.bytesIngested.count();
        long bytesProduced = this.bytesProduced.count();
        if (bytesIngested == 0L && bytesProduced == 0L) {
            return IngestStats.ByteStats.IDENTITY;
        }
        return new IngestStats.ByteStats(bytesIngested, bytesProduced);
    }
}

