/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperErrors;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperMergeContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.NestedPathFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.SourceFieldMetrics;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class NestedObjectMapper
extends ObjectMapper {
    public static final String CONTENT_TYPE = "nested";
    private final Explicit<Boolean> includeInRoot;
    private final Explicit<Boolean> includeInParent;
    private final Query parentTypeFilter;
    private final String nestedTypePath;
    private final Query nestedTypeFilter;
    private final Function<Query, BitSetProducer> bitsetProducer;
    private final IndexSettings indexSettings;

    NestedObjectMapper(String name, String fullPath, Map<String, Mapper> mappers, Explicit<Boolean> enabled, ObjectMapper.Dynamic dynamic, Optional<Mapper.SourceKeepMode> sourceKeepMode, Explicit<Boolean> includeInParent, Explicit<Boolean> includeInRoot, Query parentTypeFilter, String nestedTypePath, Query nestedTypeFilter, Function<Query, BitSetProducer> bitsetProducer, IndexSettings indexSettings) {
        super(name, fullPath, enabled, Optional.empty(), sourceKeepMode, dynamic, mappers);
        this.parentTypeFilter = parentTypeFilter;
        this.nestedTypePath = nestedTypePath;
        this.nestedTypeFilter = nestedTypeFilter;
        this.includeInParent = includeInParent;
        this.includeInRoot = includeInRoot;
        this.bitsetProducer = bitsetProducer;
        this.indexSettings = indexSettings;
    }

    public IndexSettings indexSettings() {
        return this.indexSettings;
    }

    public Query parentTypeFilter() {
        return this.parentTypeFilter;
    }

    public Query nestedTypeFilter() {
        return this.nestedTypeFilter;
    }

    public String nestedTypePath() {
        return this.nestedTypePath;
    }

    @Override
    public boolean isNested() {
        return true;
    }

    public boolean isIncludeInParent() {
        return this.includeInParent.value();
    }

    public boolean isIncludeInRoot() {
        return this.includeInRoot.value();
    }

    public Function<Query, BitSetProducer> bitsetProducer() {
        return this.bitsetProducer;
    }

    public Map<String, Mapper> getChildren() {
        return this.mappers;
    }

    @Override
    public ObjectMapper.Builder newBuilder(IndexVersion indexVersionCreated) {
        Builder builder = new Builder(this.leafName(), indexVersionCreated, this.bitsetProducer, this.indexSettings);
        builder.enabled = this.enabled;
        builder.dynamic = this.dynamic;
        builder.includeInRoot = this.includeInRoot;
        builder.includeInParent = this.includeInParent;
        return builder;
    }

    @Override
    NestedObjectMapper withoutMappers() {
        return new NestedObjectMapper(this.leafName(), this.fullPath(), Map.of(), this.enabled, this.dynamic, this.sourceKeepMode, this.includeInParent, this.includeInRoot, this.parentTypeFilter, this.nestedTypePath, this.nestedTypeFilter, this.bitsetProducer, this.indexSettings);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.leafName());
        builder.field("type", CONTENT_TYPE);
        if (this.includeInParent.explicit() && this.includeInParent.value().booleanValue()) {
            builder.field("include_in_parent", this.includeInParent.value());
        }
        if (this.includeInRoot.value().booleanValue()) {
            builder.field("include_in_root", this.includeInRoot.value());
        }
        if (this.dynamic != null) {
            builder.field("dynamic", this.dynamic.name().toLowerCase(Locale.ROOT));
        }
        if (!this.isEnabled()) {
            builder.field("enabled", (Boolean)this.enabled.value());
        }
        if (this.sourceKeepMode.isPresent()) {
            builder.field("synthetic_source_keep", (Enum)this.sourceKeepMode.get());
        }
        this.serializeMappers(builder, params);
        return builder.endObject();
    }

    @Override
    public ObjectMapper merge(Mapper mergeWith, MapperMergeContext parentMergeContext) {
        MapperBuilderContext parentBuilderContext;
        if (!(mergeWith instanceof NestedObjectMapper)) {
            MapperErrors.throwNestedMappingConflictError(mergeWith.fullPath());
        }
        NestedObjectMapper mergeWithObject = (NestedObjectMapper)mergeWith;
        MapperService.MergeReason reason = parentMergeContext.getMapperBuilderContext().getMergeReason();
        ObjectMapper.MergeResult mergeResult = ObjectMapper.MergeResult.build(this, mergeWithObject, parentMergeContext);
        Explicit<Boolean> incInParent = this.includeInParent;
        Explicit<Boolean> incInRoot = this.includeInRoot;
        if (reason == MapperService.MergeReason.INDEX_TEMPLATE) {
            if (mergeWithObject.includeInParent.explicit()) {
                incInParent = mergeWithObject.includeInParent;
            }
            if (mergeWithObject.includeInRoot.explicit()) {
                incInRoot = mergeWithObject.includeInRoot;
            }
        } else {
            if (this.includeInParent.value() != mergeWithObject.includeInParent.value()) {
                throw new MapperException("the [include_in_parent] parameter can't be updated on a nested object mapping");
            }
            if (this.includeInRoot.value() != mergeWithObject.includeInRoot.value()) {
                throw new MapperException("the [include_in_root] parameter can't be updated on a nested object mapping");
            }
        }
        if ((parentBuilderContext = parentMergeContext.getMapperBuilderContext()) instanceof NestedMapperBuilderContext) {
            NestedMapperBuilderContext nc = (NestedMapperBuilderContext)parentBuilderContext;
            if (nc.parentIncludedInRoot && incInParent.value().booleanValue()) {
                incInRoot = Explicit.IMPLICIT_FALSE;
            }
        } else if (incInParent.value().booleanValue()) {
            incInRoot = Explicit.IMPLICIT_FALSE;
        }
        return new NestedObjectMapper(this.leafName(), this.fullPath(), mergeResult.mappers(), mergeResult.enabled(), mergeResult.dynamic(), mergeResult.sourceKeepMode(), incInParent, incInRoot, this.parentTypeFilter, this.nestedTypePath, this.nestedTypeFilter, this.bitsetProducer, this.indexSettings);
    }

    @Override
    protected MapperMergeContext createChildContext(MapperMergeContext mapperMergeContext, String name) {
        MapperBuilderContext mapperBuilderContext = mapperMergeContext.getMapperBuilderContext();
        boolean parentIncludedInRoot = this.includeInRoot.value();
        if (!(mapperBuilderContext instanceof NestedMapperBuilderContext)) {
            parentIncludedInRoot |= this.includeInParent.value().booleanValue();
        }
        return mapperMergeContext.createChildContext(new NestedMapperBuilderContext(mapperBuilderContext.buildFullName(name), mapperBuilderContext.isSourceSynthetic(), mapperBuilderContext.isDataStream(), mapperBuilderContext.parentObjectContainsDimensions(), this.nestedTypeFilter, parentIncludedInRoot, mapperBuilderContext.getDynamic(this.dynamic), mapperBuilderContext.getMergeReason()));
    }

    @Override
    SourceLoader.SyntheticFieldLoader syntheticFieldLoader(SourceFilter filter, Collection<Mapper> mappers, boolean isFragment) {
        if (this.sourceKeepMode.orElse(Mapper.SourceKeepMode.NONE) == Mapper.SourceKeepMode.ALL) {
            return SourceLoader.SyntheticFieldLoader.NOTHING;
        }
        SourceLoader.Synthetic sourceLoader = new SourceLoader.Synthetic(filter, () -> super.syntheticFieldLoader(filter, mappers, true), SourceFieldMetrics.NOOP);
        Set<String> requiredStoredFields = IgnoredSourceFieldMapper.ensureLoaded(sourceLoader.requiredStoredFields(), this.indexSettings);
        StoredFieldLoader storedFieldLoader = StoredFieldLoader.create(false, requiredStoredFields, true);
        return new NestedSyntheticFieldLoader(storedFieldLoader, sourceLoader, () -> this.bitsetProducer.apply(this.parentTypeFilter), this.nestedTypeFilter);
    }

    public static class Builder
    extends ObjectMapper.Builder {
        private Explicit<Boolean> includeInRoot = Explicit.IMPLICIT_FALSE;
        private Explicit<Boolean> includeInParent = Explicit.IMPLICIT_FALSE;
        private final IndexVersion indexCreatedVersion;
        private final Function<Query, BitSetProducer> bitSetProducer;
        private final IndexSettings indexSettings;

        public Builder(String name, IndexVersion indexCreatedVersion, Function<Query, BitSetProducer> bitSetProducer, IndexSettings indexSettings) {
            super(name, Optional.empty());
            this.indexCreatedVersion = indexCreatedVersion;
            this.bitSetProducer = bitSetProducer;
            this.indexSettings = indexSettings;
        }

        Builder includeInRoot(boolean includeInRoot) {
            this.includeInRoot = Explicit.explicitBoolean(includeInRoot);
            return this;
        }

        Builder includeInParent(boolean includeInParent) {
            this.includeInParent = Explicit.explicitBoolean(includeInParent);
            return this;
        }

        @Override
        public NestedObjectMapper build(MapperBuilderContext context) {
            Query parentTypeFilter;
            boolean parentIncludedInRoot = this.includeInRoot.value();
            if (context instanceof NestedMapperBuilderContext) {
                NestedMapperBuilderContext nc = (NestedMapperBuilderContext)context;
                if (nc.parentIncludedInRoot && this.includeInParent.value().booleanValue()) {
                    this.includeInRoot = Explicit.IMPLICIT_FALSE;
                }
                parentTypeFilter = nc.nestedTypeFilter;
            } else {
                parentIncludedInRoot |= this.includeInParent.value().booleanValue();
                if (this.includeInParent.value().booleanValue()) {
                    this.includeInRoot = Explicit.IMPLICIT_FALSE;
                }
                parentTypeFilter = Queries.newNonNestedFilter(this.indexCreatedVersion);
            }
            String fullPath = context.buildFullName(this.leafName());
            Object nestedTypePath = this.indexCreatedVersion.before(IndexVersions.V_8_0_0) ? "__" + fullPath : fullPath;
            if (this.sourceKeepMode.orElse(Mapper.SourceKeepMode.NONE) == Mapper.SourceKeepMode.ARRAYS) {
                throw new MapperException("parameter [ synthetic_source_keep ] can't be set to [" + String.valueOf((Object)Mapper.SourceKeepMode.ARRAYS) + "] for nested object [" + fullPath + "]");
            }
            Query nestedTypeFilter = NestedPathFieldMapper.filter(this.indexCreatedVersion, (String)nestedTypePath);
            NestedMapperBuilderContext nestedContext = new NestedMapperBuilderContext(context.buildFullName(this.leafName()), context.isSourceSynthetic(), context.isDataStream(), context.parentObjectContainsDimensions(), nestedTypeFilter, parentIncludedInRoot, context.getDynamic(this.dynamic), context.getMergeReason());
            return new NestedObjectMapper(this.leafName(), fullPath, this.buildMappers(nestedContext), this.enabled, this.dynamic, this.sourceKeepMode, this.includeInParent, this.includeInRoot, parentTypeFilter, (String)nestedTypePath, nestedTypeFilter, this.bitSetProducer, this.indexSettings);
        }
    }

    static class NestedMapperBuilderContext
    extends MapperBuilderContext {
        final boolean parentIncludedInRoot;
        final Query nestedTypeFilter;

        NestedMapperBuilderContext(String path, boolean isSourceSynthetic, boolean isDataStream, boolean parentObjectContainsDimensions, Query nestedTypeFilter, boolean parentIncludedInRoot, ObjectMapper.Dynamic dynamic, MapperService.MergeReason mergeReason) {
            super(path, isSourceSynthetic, isDataStream, parentObjectContainsDimensions, dynamic, mergeReason, true);
            this.parentIncludedInRoot = parentIncludedInRoot;
            this.nestedTypeFilter = nestedTypeFilter;
        }

        @Override
        public MapperBuilderContext createChildContext(String name, ObjectMapper.Dynamic dynamic) {
            return new NestedMapperBuilderContext(this.buildFullName(name), this.isSourceSynthetic(), this.isDataStream(), this.parentObjectContainsDimensions(), this.nestedTypeFilter, this.parentIncludedInRoot, this.getDynamic(dynamic), this.getMergeReason());
        }
    }

    private class NestedSyntheticFieldLoader
    extends SourceLoader.DocValuesBasedSyntheticFieldLoader {
        private final StoredFieldLoader storedFieldLoader;
        private final SourceLoader sourceLoader;
        private final Supplier<BitSetProducer> parentBitSetProducer;
        private final Query childFilter;
        private LeafStoredFieldLoader leafStoredFieldLoader;
        private SourceLoader.Leaf leafSourceLoader;
        private final List<Integer> children = new ArrayList<Integer>();

        private NestedSyntheticFieldLoader(StoredFieldLoader storedFieldLoader, SourceLoader sourceLoader, Supplier<BitSetProducer> parentBitSetProducer, Query childFilter) {
            this.storedFieldLoader = storedFieldLoader;
            this.sourceLoader = sourceLoader;
            this.parentBitSetProducer = parentBitSetProducer;
            this.childFilter = childFilter;
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            this.children.clear();
            this.leafStoredFieldLoader = this.storedFieldLoader.getLoader(leafReader.getContext(), null);
            this.leafSourceLoader = this.sourceLoader.leaf(leafReader, null);
            IndexSearcher searcher = new IndexSearcher(leafReader);
            searcher.setQueryCache(null);
            Scorer childScorer = searcher.createWeight(this.childFilter, ScoreMode.COMPLETE_NO_SCORES, 1.0f).scorer(leafReader.getContext());
            if (childScorer != null) {
                BitSet parentDocs = this.parentBitSetProducer.get().getBitSet(leafReader.getContext());
                return parentDoc -> {
                    this.collectChildren(parentDoc, parentDocs, childScorer.iterator());
                    return this.children.size() > 0;
                };
            }
            return parentDoc -> false;
        }

        private List<Integer> collectChildren(int parentDoc, BitSet parentDocs, DocIdSetIterator childIt) throws IOException {
            assert (parentDoc < 0 || parentDocs.get(parentDoc)) : "wrong context, doc " + parentDoc + " is not a parent of " + NestedObjectMapper.this.nestedTypePath;
            int prevParentDoc = parentDoc > 0 ? parentDocs.prevSetBit(parentDoc - 1) : -1;
            int childDocId = childIt.docID();
            if (childDocId <= prevParentDoc) {
                childDocId = childIt.advance(prevParentDoc + 1);
            }
            this.children.clear();
            while (childDocId < parentDoc) {
                this.children.add(childDocId);
                childDocId = childIt.nextDoc();
            }
            return this.children;
        }

        @Override
        public boolean hasValue() {
            return this.children.size() > 0;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            assert (this.children != null && this.children.size() > 0);
            if (this.children.size() == 1) {
                b.field(NestedObjectMapper.this.leafName());
                this.leafStoredFieldLoader.advanceTo(this.children.get(0));
                this.leafSourceLoader.write(this.leafStoredFieldLoader, this.children.get(0), b);
            } else {
                b.startArray(NestedObjectMapper.this.leafName());
                for (int childId : this.children) {
                    this.leafStoredFieldLoader.advanceTo(childId);
                    this.leafSourceLoader.write(this.leafStoredFieldLoader, childId, b);
                }
                b.endArray();
            }
        }

        @Override
        public String fieldName() {
            return NestedObjectMapper.this.fullPath();
        }

        @Override
        public void reset() {
            this.children.clear();
        }
    }

    public static class TypeParser
    extends ObjectMapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            if (TypeParser.parseSubobjects(node).isPresent()) {
                throw new MapperParsingException("Nested type [" + name + "] does not support [subobjects] parameter");
            }
            Builder builder = new Builder(name, parserContext.indexVersionCreated(), parserContext::bitSetProducer, parserContext.getIndexSettings());
            TypeParser.parseNested(name, node, builder);
            TypeParser.parseObjectFields(node, parserContext, builder);
            return builder;
        }

        protected static void parseNested(String name, Map<String, Object> node, Builder builder) {
            Object fieldNode = node.get("include_in_parent");
            if (fieldNode != null) {
                boolean includeInParent = XContentMapValues.nodeBooleanValue(fieldNode, name + ".include_in_parent");
                builder.includeInParent(includeInParent);
                node.remove("include_in_parent");
            }
            if ((fieldNode = node.get("include_in_root")) != null) {
                boolean includeInRoot = XContentMapValues.nodeBooleanValue(fieldNode, name + ".include_in_root");
                builder.includeInRoot(includeInRoot);
                node.remove("include_in_root");
            }
        }
    }
}

