"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUsageMetricsRoute = exports.UsageMetricsRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _autoops_api = require("../../services/autoops_api");
var _rest_types = require("../../../common/rest_types");
var _common = require("../../../common");
var _usage_metrics_handler = require("./usage_metrics_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerUsageMetricsRoute = (router, dataUsageContext) => {
  router.versioned.post({
    access: 'internal',
    path: _common.DATA_USAGE_METRICS_API_ROUTE,
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to scoped ES client'
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: UsageMetricsRequestSchema
      },
      response: {
        200: UsageMetricsResponseSchema
      }
    }
  }, (0, _usage_metrics_handler.getUsageMetricsHandler)(dataUsageContext));
};
exports.registerUsageMetricsRoute = registerUsageMetricsRoute;
const DateSchema = _configSchema.schema.string({
  minLength: 1,
  validate: v => v.trim().length ? undefined : 'Date ISO string must not be empty'
});
const UsageMetricsRequestSchema = exports.UsageMetricsRequestSchema = _configSchema.schema.object({
  from: DateSchema,
  to: DateSchema,
  metricTypes: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    minSize: 1,
    validate: values => {
      const trimmedValues = values.map(v => v.trim());
      if (trimmedValues.some(v => !v.length)) {
        return '[metricTypes] list cannot contain empty values';
      } else if (trimmedValues.some(v => !(0, _rest_types.isMetricType)(v))) {
        return `must be one of ${_rest_types.METRIC_TYPE_VALUES.join(', ')}`;
      }
    }
  }),
  dataStreams: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    validate: values => {
      if (values.map(v => v.trim()).some(v => !v.length)) {
        return 'list cannot contain empty values';
      }
    }
  })
});
const UsageMetricsResponseSchema = {
  body: () => _configSchema.schema.recordOf(_autoops_api.metricTypesSchema, _configSchema.schema.arrayOf(_configSchema.schema.object({
    name: _configSchema.schema.string(),
    error: _configSchema.schema.nullable(_configSchema.schema.string()),
    data: _configSchema.schema.arrayOf(_configSchema.schema.object({
      x: _configSchema.schema.number(),
      y: _configSchema.schema.number()
    }))
  })))
};