"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateDefaultPipeline = exports.UpdateDefaultPipelineApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateDefaultPipeline = async args => {
  var _args$http;
  const route = '/internal/content_connectors/connectors/default_pipeline';
  const pipeline = {
    extract_binary_content: args.extract_binary_content,
    name: args.name,
    reduce_whitespace: args.reduce_whitespace,
    run_ml_inference: args.run_ml_inference
  };
  await ((_args$http = args.http) === null || _args$http === void 0 ? void 0 : _args$http.put(route, {
    body: JSON.stringify(pipeline)
  }));
  return pipeline;
};
exports.updateDefaultPipeline = updateDefaultPipeline;
const UpdateDefaultPipelineApiLogic = exports.UpdateDefaultPipelineApiLogic = (0, _create_api_logic.createApiLogic)(['content', 'update_default_pipeline_api_logic'], updateDefaultPipeline, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.contentConnectors.content.indices.defaultPipelines.successToast.title', {
    defaultMessage: 'Default pipeline successfully updated'
  })
});