"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactShortcuts = require("react-shortcuts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _i18n2 = require("../../../i18n");
var _tool_tip_shortcut = require("../tool_tip_shortcut");
var _refresh_control = require("./refresh_control");
var _fullscreen_control = require("./fullscreen_control");
var _edit_menu = require("./edit_menu");
var _element_menu = require("./element_menu");
var _share_menu = require("./share_menu");
var _view_menu = require("./view_menu");
var _labs_control = require("./labs_control");
var _editor_menu = require("./editor_menu");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error no @types definition

// @ts-expect-error untyped local

const strings = {
  getQuickCreateButtonGroupLegend: () => _i18n.i18n.translate('xpack.canvas.workpadHeader.quickCreateButtonGroupLegend', {
    defaultMessage: 'Shortcuts to popular element types'
  }),
  getFullScreenButtonAriaLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeader.fullscreenButtonAriaLabel', {
    defaultMessage: 'View fullscreen'
  }),
  getFullScreenTooltip: () => _i18n.i18n.translate('xpack.canvas.workpadHeader.fullscreenTooltip', {
    defaultMessage: 'Enter fullscreen mode'
  }),
  getHideEditControlTooltip: () => _i18n.i18n.translate('xpack.canvas.workpadHeader.hideEditControlTooltip', {
    defaultMessage: 'Hide editing controls'
  }),
  getNoWritePermissionTooltipText: () => _i18n.i18n.translate('xpack.canvas.workpadHeader.noWritePermissionTooltip', {
    defaultMessage: "You don't have permission to edit this workpad"
  }),
  getShowEditControlTooltip: () => _i18n.i18n.translate('xpack.canvas.workpadHeader.showEditControlTooltip', {
    defaultMessage: 'Show editing controls'
  })
};
const elementStrings = (0, _i18n2.getElementStrings)();
const WorkpadHeader = ({
  isWriteable,
  canUserWrite,
  commit,
  onSetWriteable = () => {},
  renderEmbedPanel,
  elements,
  addElement
}) => {
  const [isEmbedPanelVisible, setEmbedPanelVisible] = (0, _react.useState)(false);
  const hideEmbedPanel = () => setEmbedPanelVisible(false);
  const showEmbedPanel = () => setEmbedPanelVisible(true);
  const toggleWriteable = () => onSetWriteable(!isWriteable);
  const keyHandler = action => {
    if (action === 'EDITING') {
      toggleWriteable();
    }
  };
  const fullscreenButton = ({
    toggleFullscreen
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: /*#__PURE__*/_react.default.createElement("span", null, strings.getFullScreenTooltip(), ' ', /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
      namespace: "PRESENTATION",
      action: "FULLSCREEN"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "fullScreen",
    "aria-label": strings.getFullScreenButtonAriaLabel(),
    onClick: toggleFullscreen
  }));
  const getEditToggleToolTipText = () => {
    if (!canUserWrite) {
      return strings.getNoWritePermissionTooltipText();
    }
    const content = isWriteable ? strings.getHideEditControlTooltip() : strings.getShowEditControlTooltip();
    return content;
  };
  const getEditToggleToolTip = ({
    textOnly
  } = {
    textOnly: false
  }) => {
    const content = getEditToggleToolTipText();
    if (textOnly) {
      return content;
    }
    return /*#__PURE__*/_react.default.createElement("span", null, content, " ", /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
      namespace: "EDITOR",
      action: "EDITING"
    }));
  };
  const createElement = (0, _react.useCallback)(elementName => () => {
    const elementSpec = elements[elementName];
    if (elementSpec) {
      addElement(elements[elementName]);
    }
  }, [addElement, elements]);
  const quickButtons = [{
    iconType: 'visText',
    label: elementStrings.markdown.displayName,
    onClick: createElement('markdown')
  }, {
    iconType: 'node',
    label: elementStrings.shape.displayName,
    onClick: createElement('shape')
  }, {
    iconType: 'image',
    label: elementStrings.image.displayName,
    onClick: createElement('image')
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    className: "canvasLayout__stageHeaderInner"
  }, isWriteable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.Toolbar, null, {
    primaryButton: /*#__PURE__*/_react.default.createElement(_element_menu.ElementMenu, {
      addElement: addElement,
      elements: elements
    }),
    iconButtonGroup: /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.IconButtonGroup, {
      buttons: quickButtons,
      legend: strings.getQuickCreateButtonGroupLegend()
    }),
    extraButtons: [/*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.AddFromLibraryButton, {
      onClick: showEmbedPanel,
      "data-test-subj": "canvas-add-from-library-button"
    }), /*#__PURE__*/_react.default.createElement(_editor_menu.EditorMenu, null)]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_view_menu.ViewMenu, null)), isWriteable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_edit_menu.EditMenu, {
    commit: commit
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_share_menu.ShareMenu, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_labs_control.LabsControl, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, canUserWrite && /*#__PURE__*/_react.default.createElement(_reactShortcuts.Shortcuts, {
    name: "EDITOR",
    handler: keyHandler,
    targetNodeSelector: "body",
    global: true,
    isolate: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: getEditToggleToolTip()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isWriteable ? 'eyeClosed' : 'eye',
    onClick: toggleWriteable,
    size: "s",
    "aria-label": getEditToggleToolTipText(),
    isDisabled: !canUserWrite
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_refresh_control.RefreshControl, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_fullscreen_control.FullscreenControl, null, fullscreenButton))))), isEmbedPanelVisible ? renderEmbedPanel(hideEmbedPanel) : null);
};
exports.WorkpadHeader = WorkpadHeader;
WorkpadHeader.propTypes = {
  // @ts-expect-error upgrade typescript v5.9.3
  isWriteable: _propTypes.default.bool,
  commit: _propTypes.default.func.isRequired,
  onSetWriteable: _propTypes.default.func,
  // @ts-expect-error upgrade typescript v5.9.3
  canUserWrite: _propTypes.default.bool,
  renderEmbedPanel: _propTypes.default.func.isRequired,
  // @ts-expect-error upgrade typescript v5.9.3
  elements: _propTypes.default.object.isRequired,
  addElement: _propTypes.default.func.isRequired
};