"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SidebarHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _tool_tip_shortcut = require("../tool_tip_shortcut");
var _shortcuts = require("../../../i18n/shortcuts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getBringForwardAriaLabel: () => _i18n.i18n.translate('xpack.canvas.sidebarHeader.bringForwardArialLabel', {
    defaultMessage: 'Move element up one layer'
  }),
  getBringToFrontAriaLabel: () => _i18n.i18n.translate('xpack.canvas.sidebarHeader.bringToFrontArialLabel', {
    defaultMessage: 'Move element to top layer'
  }),
  getSendBackwardAriaLabel: () => _i18n.i18n.translate('xpack.canvas.sidebarHeader.sendBackwardArialLabel', {
    defaultMessage: 'Move element down one layer'
  }),
  getSendToBackAriaLabel: () => _i18n.i18n.translate('xpack.canvas.sidebarHeader.sendToBackArialLabel', {
    defaultMessage: 'Move element to bottom layer'
  })
};
const shortcutHelp = _shortcuts.ShortcutStrings.getShortcutHelp();
const SidebarHeader = ({
  title,
  showLayerControls = false,
  bringToFront,
  bringForward,
  sendBackward,
  sendToBack
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  className: "canvasLayout__sidebarHeader",
  gutterSize: "none",
  alignItems: "center",
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h3", null, title))), showLayerControls ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "bottom",
  content: /*#__PURE__*/_react.default.createElement("span", null, shortcutHelp.BRING_TO_FRONT, /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
    namespace: "ELEMENT",
    action: "BRING_TO_FRONT"
  }))
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  color: "text",
  iconType: "sortUp",
  onClick: bringToFront,
  "aria-label": strings.getBringToFrontAriaLabel()
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "bottom",
  content: /*#__PURE__*/_react.default.createElement("span", null, shortcutHelp.BRING_FORWARD, /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
    namespace: "ELEMENT",
    action: "BRING_FORWARD"
  }))
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  color: "text",
  iconType: "arrowUp",
  onClick: bringForward,
  "aria-label": strings.getBringForwardAriaLabel()
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "bottom",
  content: /*#__PURE__*/_react.default.createElement("span", null, shortcutHelp.SEND_BACKWARD, /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
    namespace: "ELEMENT",
    action: "SEND_BACKWARD"
  }))
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  color: "text",
  iconType: "arrowDown",
  onClick: sendBackward,
  "aria-label": strings.getSendBackwardAriaLabel()
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "bottom",
  content: /*#__PURE__*/_react.default.createElement("span", null, shortcutHelp.SEND_TO_BACK, /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
    namespace: "ELEMENT",
    action: "SEND_TO_BACK"
  }))
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  color: "text",
  iconType: "sortDown",
  onClick: sendToBack,
  "aria-label": strings.getSendToBackAriaLabel()
}))))) : null);
exports.SidebarHeader = SidebarHeader;